/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing;

import com.wily.ui.IGenericServices;
import com.wily.ui.WilyTextField;
import com.wily.util.validate.ValidationException;
import com.wily.wilyassert.Assertion;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;

public class ExtendedJComboBox
extends JComboBox {
    private static final long serialVersionUID = 5039797140050730195L;
    private IGenericServices fGenericServices;
    private ExtendedComboBoxEditor fEditor;
    private Object fPreviousItem;

    protected ExtendedJComboBox() {
        Assertion.unimplemented("Must at least specify GenericServices");
    }

    public ExtendedJComboBox(IGenericServices genericServices) {
        this.init(genericServices);
    }

    public ExtendedJComboBox(IGenericServices genericServices, Vector items) {
        super(items);
        this.init(genericServices);
    }

    public ExtendedJComboBox(IGenericServices genericServices, ComboBoxModel aModel) {
        super(aModel);
        this.init(genericServices);
    }

    public ExtendedJComboBox(IGenericServices genericServices, Object[] items) {
        super(items);
        this.init(genericServices);
    }

    private void init(IGenericServices genericServices) {
        this.fGenericServices = genericServices;
        this.fEditor = new ExtendedComboBoxEditor(this.getGenericServices());
        this.setEditor(this.fEditor);
        this.addItemListener(new ItemChangeListener());
    }

    protected IGenericServices getGenericServices() {
        return this.fGenericServices;
    }

    public void setColumns(int width) {
        this.fEditor.setColumns(width);
    }

    public int getColumns() {
        return this.fEditor.getColumns();
    }

    public void setPreviousSelection(Object item) {
        this.fPreviousItem = item;
    }

    public void setPreviouslySelectedIndex() {
        this.setPreviouslySelectedItem();
    }

    public void setPreviouslySelectedItem() {
        if (this.fPreviousItem != null) {
            this.setSelectedItem(this.fPreviousItem);
        } else {
            this.setSelectedIndex(0);
        }
    }

    public void IValidatable_validate(int validationConstants) throws ValidationException {
        this.fEditor.IValidatable_validate(validationConstants);
    }

    class ExtendedComboBoxEditor
    extends WilyTextField
    implements ComboBoxEditor {
        private static final long serialVersionUID = -6080559607636960037L;

        public ExtendedComboBoxEditor(IGenericServices genericServices) {
            super(genericServices);
            this.setBorder(null);
        }

        public void addActionListener(ActionListener l) {
            super.addActionListener(l);
        }

        public void removeActionListener(ActionListener l) {
            super.removeActionListener(l);
        }

        public Component getEditorComponent() {
            return this;
        }

        public Object getItem() {
            return super.getText();
        }

        public void selectAll() {
            String text = super.getText();
            super.setSelectionStart(0);
            super.setSelectionEnd(text.length());
        }

        public void setItem(Object anObject) {
            super.setText((String)anObject);
        }
    }

    private class ItemChangeListener
    implements ItemListener {
        private ItemChangeListener() {
        }

        public void itemStateChanged(ItemEvent event) {
            if (event.getStateChange() == 2) {
                ExtendedJComboBox.this.fPreviousItem = event.getItem();
            }
        }
    }
}

