/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.validate;

import com.wily.util.text.CompoundLocalizableMessage;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.SimpleLocalizableMessage;
import com.wily.util.text.TextUtilities;
import com.wily.util.validate.ValidationException;

public class IdentifiableObjectValidationException
extends ValidationException {
    private static final long serialVersionUID = 4149455682634441839L;
    private ILocalizableMessage fInvalidObjectIdentifier;
    private ILocalizableMessage fInvalidObjectRequiredCondition;

    public IdentifiableObjectValidationException() {
        this.init(null, null);
    }

    public IdentifiableObjectValidationException(ILocalizableMessage invalidObjectRequiredCondition) {
        this.init(null, invalidObjectRequiredCondition);
    }

    public IdentifiableObjectValidationException(ILocalizableMessage invalidObjectIdentifier, ILocalizableMessage invalidObjectRequiredCondition) {
        this.init(invalidObjectIdentifier, invalidObjectRequiredCondition);
    }

    public IdentifiableObjectValidationException(ILocalizableMessage userMessagePrefix, ILocalizableMessage invalidObjectIdentifier, ILocalizableMessage invalidObjectRequiredCondition) {
        super(userMessagePrefix);
        this.init(invalidObjectIdentifier, invalidObjectRequiredCondition);
    }

    private void init(ILocalizableMessage invalidObjectIdentifier, ILocalizableMessage invalidObjectRequiredCondition) {
        this.fInvalidObjectIdentifier = invalidObjectIdentifier;
        if (this.fInvalidObjectIdentifier == null) {
            this.fInvalidObjectIdentifier = new SimpleLocalizableMessage("Validation_Default_Invalid_Object_Identifier");
        }
        this.fInvalidObjectRequiredCondition = invalidObjectRequiredCondition;
        if (this.fInvalidObjectRequiredCondition == null) {
            this.fInvalidObjectRequiredCondition = new SimpleLocalizableMessage("Validation_Default_Invalid_Object_Required_Condition");
        }
    }

    public ILocalizableMessage getRequiredCondition() {
        return new CompoundLocalizableMessage(this.getInvalidObjectIdentifier(), TextUtilities.getSpaceLocalizableMessage(), this.getInvalidObjectRequiredCondition());
    }

    public ILocalizableMessage getInvalidObjectIdentifier() {
        return this.fInvalidObjectIdentifier;
    }

    public ILocalizableMessage getInvalidObjectRequiredCondition() {
        return this.fInvalidObjectRequiredCondition;
    }
}

