/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.commandline;

import com.wily.util.text.IStringLocalizer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;

public class CommandLinePrompt {
    private static final int kInvalidInteger = -1;
    private static final char kInvalidChar = '\u0000';
    private final LineNumberReader fInput;
    private final PrintWriter fOutput;
    private final IStringLocalizer fLocalizer;

    public CommandLinePrompt(InputStream input, PrintWriter output, IStringLocalizer localizer) {
        this.fInput = new LineNumberReader(new InputStreamReader(input));
        this.fOutput = output;
        this.fLocalizer = localizer;
    }

    private char readCharacter(char[] options) {
        try {
            char ch;
            String line = this.fInput.readLine();
            if (line != null && line.length() > 0 && this.linearSearch(options, ch = Character.toLowerCase(line.charAt(0))) >= 0) {
                return ch;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return '\u0000';
    }

    private int linearSearch(char[] options, char ch) {
        if (options != null) {
            for (int i = 0; i < options.length; ++i) {
                if (options[i] != ch) continue;
                return i;
            }
        }
        return -1;
    }

    private int readInteger(int min, int max) {
        try {
            String line = this.fInput.readLine();
            int value = Integer.parseInt(line);
            if (value >= min && value <= max) {
                return value;
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1;
    }

    public char showPrompt(String localizedPrompt, char[] validResponses) {
        String[] arr = new String[]{localizedPrompt};
        return this.showPrompt(arr, validResponses);
    }

    public char showPrompt(String[] localizedPrompt, char[] validResponses) {
        int i;
        if (localizedPrompt == null) {
            throw new IllegalArgumentException("a prompt must be specified");
        }
        if (validResponses == null || validResponses.length == 0) {
            throw new IllegalArgumentException("at least one response must be specified!");
        }
        char choice = '\u0000';
        for (i = 0; i < validResponses.length; ++i) {
            validResponses[i] = Character.toLowerCase(validResponses[i]);
        }
        while (choice == '\u0000') {
            for (i = 0; i < localizedPrompt.length; ++i) {
                this.fOutput.print(localizedPrompt[i]);
                if (i < localizedPrompt.length - 1) {
                    this.fOutput.println();
                    continue;
                }
                this.fOutput.print(" ");
            }
            this.fOutput.flush();
            choice = this.readCharacter(validResponses);
            if (choice != '\u0000') continue;
        }
        return choice;
    }

    public int showPrompt(String promptKey, String[] optionKeys) {
        if (optionKeys == null || optionKeys.length == 0) {
            throw new IllegalArgumentException("at least one option must be specified!");
        }
        String locPrompt = this.fLocalizer.IStringLocalizer_getLocalizedString(promptKey);
        String[] locOptions = this.fLocalizer.IStringLocalizer_getLocalizedStrings(optionKeys);
        int choice = -1;
        int max = locOptions.length;
        String maxStr = String.valueOf(max);
        while (choice == -1) {
            this.fOutput.println(locPrompt);
            for (int i = 0; i < locOptions.length; ++i) {
                this.fOutput.println(i + 1 + ". " + locOptions[i]);
            }
            this.fOutput.print("(1-" + maxStr + ")> ");
            this.fOutput.flush();
            choice = this.readInteger(1, max);
            if (choice != -1) continue;
        }
        return choice - 1;
    }
}

