/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.task;

import com.wily.util.adt.BlockingQueue;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.task.AAsynchTask;
import com.wily.util.task.ASimpleExecutableItem;
import com.wily.util.task.IExecutableItem;
import com.wily.util.task.IExecutionQueue;
import com.wily.util.task.TaskAlreadyStartedException;
import com.wily.util.task.TaskException;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.thread.IThreadFactory;

public class AsynchExecutionQueue
extends AAsynchTask
implements IExecutionQueue {
    private static final String kDefaultName = "Asynchronous Execution Queue";
    private final IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;
    private final IThreadFactory fThreadFactory;
    private final BlockingQueue fInternalQueue;
    private final String fName;

    public AsynchExecutionQueue() {
        this(kDefaultName, null, null, null, true);
    }

    public AsynchExecutionQueue(String name) {
        this(name, null, null, null, true);
    }

    public AsynchExecutionQueue(String name, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        this(name, feedback, localizer, null, true);
    }

    public AsynchExecutionQueue(String name, IModuleFeedbackChannel feedback, IStringLocalizer localizer, boolean shouldStart) {
        this(name, feedback, localizer, null, shouldStart);
    }

    public AsynchExecutionQueue(String name, IModuleFeedbackChannel feedback, IStringLocalizer localizer, IThreadFactory factory) {
        this(name, feedback, localizer, factory, true);
    }

    public AsynchExecutionQueue(String name, IModuleFeedbackChannel feedback, IStringLocalizer localizer, IThreadFactory factory, boolean shouldStart) {
        this.fName = name;
        this.fFeedback = feedback;
        this.fLocalizer = localizer;
        this.fThreadFactory = factory;
        this.fInternalQueue = new BlockingQueue(this.fName, this.fFeedback);
        try {
            if (shouldStart) {
                this.start();
            }
        }
        catch (TaskAlreadyStartedException taskAlreadyStartedException) {
            // empty catch block
        }
    }

    public void start() throws TaskAlreadyStartedException {
        if (this.fThreadFactory != null) {
            super.ITask_startTask(this.fName + " Execution", this.fThreadFactory);
        } else {
            super.ITask_startTask(this.fName, true);
        }
    }

    private boolean hasFeedbackAndLocalizer() {
        return this.fFeedback != null && this.fLocalizer != null;
    }

    private IModuleFeedbackChannel getModuleFeedback() {
        return this.fFeedback;
    }

    private IStringLocalizer getStringLocalizer() {
        return this.fLocalizer;
    }

    public void setMaxQueueSize(int limit) {
        this.fInternalQueue.setLimit(limit);
    }

    public void setQueueDebuggingFeature(String whichFeature, String logMessage, Object parameter) {
        this.fInternalQueue.setDebuggingFeature(whichFeature, logMessage, parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTask() throws TaskException {
        IExecutableItem item = null;
        while (true) {
            this.IInterruptSource_pauseIfNecessary();
            if (this.IInterruptSource_shouldStop()) {
                this.clearQueue();
                this.IInterruptSource_hasCancelled();
                return;
            }
            try {
                item = (IExecutableItem)this.fInternalQueue.interruptableDequeue();
                try {
                    if (item.IExecutableItem_shouldStillExecute()) {
                        item.IExecutableItem_execute();
                        continue;
                    }
                    item.IExecutableItem_executionAborted();
                }
                catch (Throwable t) {
                    if (!this.hasFeedbackAndLocalizer()) continue;
                    this.getModuleFeedback().warn(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Asynch_Execution_Queue_Item_Execution_Failed"));
                    this.getModuleFeedback().error(t);
                }
                finally {
                    IExecutableItem iExecutableItem = item;
                    synchronized (iExecutableItem) {
                        item.notifyAll();
                    }
                    item = null;
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private boolean enqueue(IExecutableItem item) {
        if (!this.ITask_isCompleted()) {
            return this.fInternalQueue.enqueue(item);
        }
        this.cancelItem(item);
        return false;
    }

    private void clearQueue() {
        while (!this.fInternalQueue.isEmpty()) {
            try {
                IExecutableItem item = (IExecutableItem)this.fInternalQueue.dequeue();
                this.cancelItem(item);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelItem(IExecutableItem item) {
        try {
            item.IExecutableItem_executionAborted();
        }
        catch (Throwable t) {
            if (this.hasFeedbackAndLocalizer()) {
                if (this.getModuleFeedback().isVerboseEnabled()) {
                    this.getModuleFeedback().warn(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Asynch_Execution_Queue_Cancel_Failed"));
                }
                this.getModuleFeedback().verbose(t);
            }
        }
        finally {
            IExecutableItem iExecutableItem = item;
            synchronized (iExecutableItem) {
                item.notifyAll();
            }
        }
    }

    public void IExecutionQueue_addExecutableItem(IExecutableItem item) {
        this.enqueue(new WrapperItem(item));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void IExecutionQueue_addExecutableItemAndWait(IExecutableItem item) {
        WrapperItem wrapper;
        WrapperItem wrapperItem = wrapper = new WrapperItem(item);
        synchronized (wrapperItem) {
            if (this.enqueue(wrapper)) {
                try {
                    wrapper.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void IExecutionQueue_syncWithQueue() {
        this.IExecutionQueue_addExecutableItemAndWait(new MarkerItem());
    }

    public void IExecutionQueue_stop() {
        this.IInterruptableTask_cancelAsynch();
    }

    public void IInterruptableTask_cancelAsynch() {
        super.IInterruptableTask_cancelAsynch();
        this.interruptTask();
    }

    public void IInterruptableTask_cancelSynch() {
        super.IInterruptableTask_cancelAsynch();
        this.interruptTask();
        super.IInterruptableTask_cancelSynch();
    }

    public void IInterruptableTask_pauseAsynch() {
        super.IInterruptableTask_pauseAsynch();
        this.interruptTask();
    }

    public void IInterruptableTask_pauseSynch() {
        super.IInterruptableTask_pauseAsynch();
        this.interruptTask();
        super.IInterruptableTask_pauseSynch();
    }

    private static final class MarkerItem
    extends ASimpleExecutableItem {
        public void IExecutableItem_execute() {
        }
    }

    private static final class WrapperItem
    implements IExecutableItem {
        private IExecutableItem fItem;

        public WrapperItem(IExecutableItem item) {
            this.fItem = item;
        }

        public boolean IExecutableItem_shouldStillExecute() {
            return this.fItem.IExecutableItem_shouldStillExecute();
        }

        public void IExecutableItem_executionAborted() {
            this.fItem.IExecutableItem_executionAborted();
        }

        public void IExecutableItem_execute() {
            this.fItem.IExecutableItem_execute();
        }
    }
}

