/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public abstract class BrowserControl {
    private static final String WIN_ID = "Windows";
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static final String UNIX_PATH = "netscape";
    private static final String UNIX_FLAG = "-remote openURL";

    private BrowserControl() {
    }

    public static void displayURL(String url) {
        block7: {
            boolean windows = BrowserControl.isWindowsPlatform();
            String cmd = null;
            try {
                if (windows) {
                    Object shortcut;
                    String lowerUrl = url.toLowerCase();
                    if (lowerUrl.endsWith(".html") || lowerUrl.endsWith(".htm")) {
                        shortcut = File.createTempFile("OpenInBrowser", ".url");
                        shortcut = ((File)shortcut).getCanonicalFile();
                        ((File)shortcut).deleteOnExit();
                        PrintWriter out = new PrintWriter(new FileWriter((File)shortcut));
                        out.println("[InternetShortcut]");
                        out.print("URL=");
                        out.println(url);
                        out.close();
                        url = ((File)shortcut).getCanonicalPath();
                    }
                    cmd = "rundll32 url.dll,FileProtocolHandler " + url;
                    shortcut = Runtime.getRuntime().exec(cmd);
                    break block7;
                }
                cmd = "netscape -remote openURL(" + url + ")";
                Process p = Runtime.getRuntime().exec(cmd);
                try {
                    int exitCode = p.waitFor();
                    if (exitCode != 0) {
                        cmd = "netscape " + url;
                        p = Runtime.getRuntime().exec(cmd);
                    }
                }
                catch (InterruptedException x) {
                    System.err.println("Error bringing up browser, cmd='" + cmd + "'");
                    System.err.println("Caught: " + x);
                }
            }
            catch (IOException x) {
                System.err.println("Could not invoke browser, command=" + cmd);
                System.err.println("Caught: " + x);
            }
        }
    }

    private static boolean isWindowsPlatform() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith(WIN_ID);
    }
}

