/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.xml;

import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class BasicXMLErrorHandler
implements ErrorHandler {
    private final boolean fIgnoreWarning;
    private final boolean fIgnoreError;
    private final IModuleFeedbackChannel fModuleFeedback;
    private final IStringLocalizer fStringLocalizer;

    public BasicXMLErrorHandler(boolean ignoreWarning, boolean ignoreError, IModuleFeedbackChannel moduleFeedback, IStringLocalizer stringLocalizer) {
        this.fIgnoreWarning = ignoreWarning;
        this.fIgnoreError = ignoreError;
        this.fModuleFeedback = moduleFeedback;
        this.fStringLocalizer = stringLocalizer;
    }

    public void warning(SAXParseException exception) throws SAXException {
        if (!this.fIgnoreWarning) {
            this.simpleHandleError("Warning", exception);
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        if (!this.fIgnoreError) {
            this.simpleHandleError("Recoverable Error", exception);
        }
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        this.simpleHandleError("Fatal Error", exception);
    }

    private void simpleHandleError(String message, SAXParseException exception) throws SAXException {
        if (this.fModuleFeedback != null && this.fStringLocalizer != null) {
            String lineNumber = "" + exception.getLineNumber();
            String columnNumber = "" + exception.getColumnNumber();
            this.fModuleFeedback.error(this.fStringLocalizer.IStringLocalizer_getFormattedLocalizedString("XML_SAXParseException_Key", lineNumber, columnNumber));
        }
        throw exception;
    }
}

