/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.weblogic;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SEIStubCorrelationTracer
extends ASingleInstanceTracerFactory {
    private final IAgent agent;
    protected IModuleFeedbackChannel logger = null;
    protected boolean isShutOff = false;
    protected static Class cachedHeadersClass = null;
    protected static ClassLoader cachedHeadersClassLoader = null;
    protected static final String javaxWsHeadersKey = "javax.xml.ws.http.request.headers";

    public SEIStubCorrelationTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.agent = agent;
        this.logger = agent.IAgent_getModuleFeedback();
        WSMUtils.refreshLogLevels();
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        block4: {
            WSMUtils.getLogger().debug("START:SEIStubCorrelationTracer.ITracer_startTrace()");
            try {
                Object objPacket = data.getInvocationParameterAsObject(0);
                Field fldInvocation = objPacket.getClass().getField("invocationProperties");
                Map invocationProps = (Map)fldInvocation.get(objPacket);
                Map userHeaders = (Map)invocationProps.get(javaxWsHeadersKey);
                if (userHeaders == null) {
                    this.cacheHeadersClass(objPacket);
                    if (this.isShutOff) {
                        return;
                    }
                    userHeaders = (Map)cachedHeadersClass.newInstance();
                    invocationProps.put(javaxWsHeadersKey, userHeaders);
                }
                this.insertHTTPCorrelationInfo(userHeaders);
            }
            catch (Exception e) {
                this.isShutOff = true;
                WSMUtils.getLogger().error("SEIStubCorrelationTracer.ITracer_startTrace(). The tracer will be shut-off. " + e.getMessage());
                WSMUtils.getLogger().error(WSMUtils.dumpStackTrace(e));
                if (!WSMUtils.getLogger().isDebugEnabled()) break block4;
                WSMUtils.getLogger().debug("SEIStubCorrelationTracer.ITracer_startTrace(). The tracer will be shut-off.", (Throwable)e);
            }
        }
    }

    protected void insertHTTPCorrelationInfo(Map userHeaders) {
        if (!WSMUtils.correlationHTTPInsertionEnabled()) {
            return;
        }
        String correlationString = new CorrelationId().getOutgoingCorrelationIdStrippedForHeader();
        WSMUtils.getLogger().debug("SEIStubCorrelationTracer.ITracer_startTrace() correlationString=" + correlationString);
        List<String> correlationList = Collections.singletonList(correlationString);
        userHeaders.put("CorID", correlationList);
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return this.isShutOff;
    }

    public void ITracer_finishTrace(int arg0, InvocationData arg1) {
        if (!WSMUtils.correlationHTTPInsertionEnabled()) {
            return;
        }
        new CorrelationId().decrementCorrelationCount();
    }

    public void cacheHeadersClass(Object objPacket) {
        String headersClassName = WSMUtils.getJAXWSHeadersClassName();
        if (WSMUtils.getLogger().isDebugEnabled()) {
            WSMUtils.getLogger().debug("SEIStubCorrelationTracer.ITracer_startTrace(): handle JAX-WS headers as " + headersClassName);
        }
        try {
            Class<?> headersClass;
            ClassLoader classLoader = objPacket.getClass().getClassLoader();
            if (cachedHeadersClass != null && classLoader == cachedHeadersClassLoader) {
                return;
            }
            cachedHeadersClass = headersClass = Class.forName(headersClassName, true, classLoader);
            cachedHeadersClassLoader = classLoader;
            if (WSMUtils.getLogger().isDebugEnabled()) {
                WSMUtils.getLogger().debug("SEIStubCorrelationTracer.ITracer_startTrace(): Cached Header Class: " + cachedHeadersClass + " - " + cachedHeadersClassLoader);
            }
        }
        catch (Exception ex) {
            WSMUtils.getLogger().error("SEIStubCorrelationTracer.ITracer_startTrace(): Unable to access JAX WS Headers class: " + headersClassName + ". The tracer will be shut-off. " + ex.getMessage());
            if (WSMUtils.getLogger().isDebugEnabled()) {
                WSMUtils.getLogger().debug("SEIStubCorrelationTracer.ITracer_startTrace(): Unable to access JAX WS Headers class: " + headersClassName + ". The tracer will be shut-off.", (Throwable)ex);
            }
            this.isShutOff = true;
        }
    }
}

