/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.errors;

import com.wily.introscope.agent.CommonFeatureHelper;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.blamestackfeature.BlameStackFeatureBlameStack;
import com.wily.introscope.agent.blamestackfeature.IBlameStackFeature;
import com.wily.introscope.agent.blamestackfeature.IBlameStackFeatureFactory;
import com.wily.introscope.agent.errors.ErrorReportingService;
import com.wily.introscope.agent.errors.ErrorSnapshotFeature;
import com.wily.introscope.agent.errors.IErrorSnapshotFeature;
import com.wily.introscope.agent.errors.ILegacyErrorFeature;
import com.wily.introscope.agent.errors.Log;
import com.wily.introscope.agent.errors.NullErrorSnapshotFeature;
import com.wily.introscope.agent.errors.Throttle;
import com.wily.util.IConfigurationListener;
import com.wily.util.properties.IndexedProperties;

public class ErrorSnapshotFeatureFactory
implements IBlameStackFeatureFactory {
    private Throttle throttle;
    private int fThrottleCount;
    private IAgent fAgent;
    private static volatile IAgent sAgent = null;
    private static volatile boolean sIsAgentInOldConfig;
    private ComponentTracer componentTracer;
    private IConfigurationListener fListener;
    private static ThreadLocal thread2feature;

    static {
        thread2feature = new ThreadLocal();
    }

    public ErrorSnapshotFeatureFactory(IAgent agent) {
        this.fAgent = agent;
        this.updateThrottleCount(agent.IAgent_getIndexedProperties());
        this.componentTracer = agent.IAgent_getComponentTracer();
        this.fListener = new IConfigurationListener(){

            @Override
            public void onChange(IndexedProperties newProps) {
                ErrorSnapshotFeatureFactory.this.updateThrottleCount(newProps);
            }
        };
        this.fAgent.IAgent_getModuleFeedback().trace("the property this.componentTracer.isAgentOldMode() will be set here: " + this.componentTracer.isAgentOldMode());
        sIsAgentInOldConfig = this.componentTracer.isAgentOldMode();
        sAgent = this.fAgent;
        agent.addConfigurationListener(this.fListener);
    }

    public void updateThrottleCount(IndexedProperties indexedProps) {
        int throttleCount = indexedProps.safeGetPositiveIntProperty("introscope.agent.errorsnapshots.throttle", 10, this.fAgent.IAgent_getModuleFeedback(), this.fAgent.IAgent_getStringLocalizer());
        if (throttleCount != this.fThrottleCount) {
            this.throttle = new Throttle(this.fAgent.IAgent_getCommonHeartbeat(), this.fAgent.IAgent_getModuleFeedback(), throttleCount);
            this.fAgent.IAgent_getModuleFeedback().info("Configured error reporting throttle at " + this.throttle);
            this.fThrottleCount = throttleCount;
        }
    }

    @Override
    public IBlameStackFeature newFeature(BlameStackFeatureBlameStack stack) {
        ErrorSnapshotFeature errorSnapshotFeature = new ErrorSnapshotFeature(this.throttle, stack, this.componentTracer);
        thread2feature.set(errorSnapshotFeature);
        return errorSnapshotFeature;
    }

    public static boolean flagErrorInManagedApplication(String errorMessage) {
        if (sAgent == null) {
            return false;
        }
        if (sIsAgentInOldConfig) {
            if (Log.out.isDebugEnabled()) {
                Log.out.debug("flagErrorInManagedApplication: " + errorMessage);
            }
            if (ErrorReportingService.shouldIgnore(errorMessage)) {
                return false;
            }
            return ErrorSnapshotFeatureFactory.getFeatureForCurrentThread().flagErrorInManagedApplication(errorMessage);
        }
        ILegacyErrorFeature feature = (ILegacyErrorFeature)CommonFeatureHelper.getFeature("ErrorFeature");
        return feature.flagErrorInManagedApplication(errorMessage);
    }

    public static IErrorSnapshotFeature getFeatureForCurrentThread() {
        IErrorSnapshotFeature errorSnapshotFeature = (IErrorSnapshotFeature)thread2feature.get();
        if (errorSnapshotFeature == null) {
            errorSnapshotFeature = NullErrorSnapshotFeature.INSTANCE;
        }
        return errorSnapshotFeature;
    }

    public static void forgetFeatureForCurrentThread() {
        thread2feature.set(null);
    }

    public static void setAgent(IAgent agent) {
        sAgent = agent;
        sIsAgentInOldConfig = sAgent.IAgent_getComponentTracer().isAgentOldMode();
    }
}

