/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.filter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.filter.ISamplerEx;
import com.wily.introscope.install.KIntroscopeConfigConstants;
import com.wily.util.IConfigurationListener;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.properties.IndexedProperties;
import java.util.Set;

abstract class IntervalBasedSampler
implements ISamplerEx,
IConfigurationListener {
    private boolean fEnabled;
    private boolean fMasterEnabled;
    protected int fDuration;
    protected IntervalHeartbeat fTimer;
    private final ITimestampedRunnable fTimerBehavior = new ITimestampedRunnable(){

        @Override
        public void ITimestampedRunnable_execute(long nowInMillis) {
            IntervalBasedSampler.this.onDurationExpired();
        }
    };
    private IRegisteredBehavior fTimerRegisteredBehavior;
    protected IModuleFeedbackChannel fFeedback;

    IntervalBasedSampler() {
    }

    protected abstract String name();

    @Override
    public void onChange(IndexedProperties newProps) {
        this.updateEnabled(newProps.getProperty("introscope.agent.transactiontracer.sampling.enabled.set", ""));
    }

    @Override
    public void configure(IAgent agent) {
        this.fFeedback = agent.IAgent_getModuleFeedback();
        agent.addConfigurationListener(this);
        this.fTimer = agent.IAgent_getCommonHeartbeat();
        this.initMainTimer();
    }

    protected void cleanup() {
        this.fTimerRegisteredBehavior.close();
        this.fTimerRegisteredBehavior = null;
    }

    protected void initMainTimer() {
        if (this.fTimer == null) {
            return;
        }
        if (this.fTimerRegisteredBehavior != null) {
            this.cleanup();
        }
        if (!this.isEnabled()) {
            return;
        }
        String name = this.name();
        if (this.fFeedback.isTraceEnabled(kSamplingModule)) {
            this.fFeedback.trace(kSamplingModule, "Initializing main timer for " + name + ", interval duration is " + this.fDuration);
        }
        this.fTimerRegisteredBehavior = this.fTimer.addBehavior(this.fTimerBehavior, "TT Sampling " + name, true, (long)(this.fDuration * 1000), true);
    }

    private void updateEnabled(String text) {
        String name;
        Set set = text.length() == 0 ? KIntroscopeConfigConstants.kDefaultSamplingEnabledSet : StringUtils.parseAndTrimListToSet(text, ",");
        boolean enabled = set.contains(name = this.name());
        if (enabled) {
            this.fFeedback.info(kSamplingModule, "introscope.agent.transactiontracer.sampling.enabled.set property now has value=\"" + text + "\", which yields to TransactionSampling strategy " + name + " to be enabled (if overall transaction tracing is enabled)");
        } else {
            this.fFeedback.info(kSamplingModule, "introscope.agent.transactiontracer.sampling.enabled.set property now has value=\"" + text + "\", which yields to TransactionSampling strategy " + name + " to be disabled");
        }
        this.updateEnabled(enabled);
    }

    private void updateEnabled(boolean value) {
        if (value == this.fEnabled) {
            return;
        }
        this.fEnabled = value;
        this.initMainTimer();
    }

    @Override
    public void masterEnable(boolean value) {
        if (this.fMasterEnabled == value) {
            return;
        }
        this.fMasterEnabled = value;
        this.initMainTimer();
    }

    protected boolean isEnabled() {
        return this.fEnabled && this.fMasterEnabled;
    }

    protected void updateSamplingDuration(int duration) {
        if (duration == this.fDuration) {
            return;
        }
        this.fDuration = duration;
        this.initMainTimer();
    }

    protected abstract void onDurationExpired();
}

