/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.servlet;

import com.wily.introscope.agent.util.ByteClassUtil;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BytecodeClassLoader
extends ClassLoader {
    private final WeakReference<ClassLoader> parentReference;
    private static final Map<String, byte[]> repository = Collections.synchronizedMap(new HashMap());

    public BytecodeClassLoader(ClassLoader parent, ClassLoader classClassLoader, String[] classNames, IModuleFeedbackChannel feedback) {
        this.parentReference = new WeakReference<ClassLoader>(parent);
        if (classNames != null) {
            int i = 0;
            while (i < classNames.length) {
                feedback.debug("ByteCodeClassLoader looking for helper class: " + classNames[i]);
                try {
                    if (!repository.containsKey(classNames[i])) {
                        feedback.debug("Loading helper class bytes for class: " + classNames[i]);
                        feedback.debug("Helper Classloader: " + classClassLoader);
                        byte[] code = ByteClassUtil.getBytesForClass(classClassLoader, classNames[i], Integer.MAX_VALUE, feedback);
                        repository.put(classNames[i], code);
                    }
                }
                catch (IOException e) {
                    feedback.error("Failed to load helper class bytes for class: " + classNames[i]);
                    StringWriter stack = new StringWriter();
                    e.printStackTrace(new PrintWriter(stack));
                    feedback.error(stack.toString());
                }
                ++i;
            }
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        if (repository.containsKey(name)) {
            byte[] code = repository.get(name);
            return this.defineClass(name, code, 0, code.length);
        }
        ClassLoader parent = (ClassLoader)this.parentReference.get();
        if (parent == null) {
            throw new ClassNotFoundException(name);
        }
        return parent.loadClass(name);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class result = this.findClass(name);
        if (result != null) {
            return result;
        }
        ClassLoader parent = (ClassLoader)this.parentReference.get();
        if (parent == null) {
            throw new ClassNotFoundException(name);
        }
        return parent.loadClass(name);
    }
}

