/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent;

import com.wily.introscope.agent.AgentEventPublisher;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.ConflictingTypesException;
import com.wily.introscope.spec.metric.MetricNotFoundException;
import com.wily.introscope.spec.metric.TypeInquisitor;
import com.wily.util.adt.IConcurrentMap;
import com.wily.util.adt.IGuaranteedCounter;
import com.wily.util.adt.IObjectAction;
import com.wily.util.adt.IObjectFilter;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.ILocalizableMessage;
import java.util.ArrayList;
import java.util.Map;

public class ConcurrentAgentMetricPool
implements AgentMetric.IAgentMetricPool {
    private final IConcurrentMap fMetricMap;
    private int fMetricClamp = -1;
    private final IGuaranteedCounter fMetricCounter;
    private IModuleFeedbackChannel fFeedbackChannel;
    public static final AgentMetric[] kZeroLengthAgentMetricArray = new AgentMetric[0];
    private static volatile byte fMetricClampStatus = 0;
    private volatile IAgent fAgent;

    public ConcurrentAgentMetricPool(IAgent agent) {
        this.fAgent = agent;
        this.fFeedbackChannel = agent.IAgent_getModuleFeedback();
        this.fMetricMap = (IConcurrentMap)agent.IAgent_getConcurrentMapFactory().getConcurrentMap("AgentMetricPool");
        this.fMetricCounter = agent.IAgent_getGuaranteedCounter();
    }

    public void setMetricClamp(int clampVal) {
        this.fMetricCounter.getAndSet(this.fMetricMap.size());
        this.fMetricClamp = clampVal;
    }

    public int getMetricClamp() {
        return this.fMetricClamp;
    }

    private boolean checkMetricClamp() {
        if (this.fMetricClamp > 0) {
            int metricCount = this.fMetricCounter.peek();
            if (metricCount >= this.fMetricClamp) {
                if (fMetricClampStatus != 1) {
                    this.fFeedbackChannel.warn("Absolute metric clamp of " + this.fMetricClamp + " reached, no more metrics can be created.  Instrumentation on this application should be reduced.");
                    this.fFeedbackChannel.warn("Note: if no more metrics can be created when the agent starts up, there may be exceptions in the startup process. Increasing the clamp value may solve these exceptions.");
                    AgentEventPublisher.getInstance(this.fAgent).publishClampEvent(this.fMetricClamp, metricCount, true);
                    fMetricClampStatus = 1;
                }
                return false;
            }
            if (fMetricClampStatus == 1) {
                AgentEventPublisher.getInstance(this.fAgent).publishClampEvent(this.fMetricClamp, metricCount, false);
                fMetricClampStatus = (byte)2;
            }
        }
        return true;
    }

    @Override
    public AgentMetric lookupMetricWithTypeCheck(String metricName, int metricType, boolean doUntypedLookup, boolean insertOnFailure, int persistentId) throws BadlyFormedNameException, ConflictingTypesException {
        int existingType;
        boolean doTypeCheck = doUntypedLookup;
        int type = doUntypedLookup ? 15 : metricType;
        AgentMetric.AgentMetricKey key = new AgentMetric.AgentMetricKey(metricName, type);
        AgentMetric result = null;
        result = (AgentMetric)this.fMetricMap.get(key);
        if (result == null && insertOnFailure) {
            if (this.checkMetricClamp()) {
                AgentMetric.AgentMetricKey newKey = new AgentMetric.AgentMetricKey(metricName, metricType);
                AgentMetric value = new AgentMetric(metricName, metricType, persistentId);
                doTypeCheck = false;
                result = (AgentMetric)this.fMetricMap.putIfAbsent(newKey, value);
                if (result == null) {
                    result = value;
                    this.fMetricCounter.next();
                }
            } else {
                return AgentMetric.kNullAgentMetric;
            }
        }
        if (result != null && doTypeCheck && !TypeInquisitor.isSameType(existingType = result.getAttributeType(), metricType)) {
            FormattedLocalizableMessage message = new FormattedLocalizableMessage("Metric_Type_Mismatch", metricName);
            throw new ConflictingTypesException("Mismatched metric types for " + metricName + ": Existing=" + existingType + " Requested=" + metricType, (ILocalizableMessage)message);
        }
        return result;
    }

    @Override
    public AgentMetric lookupExistingMetric(String metricName, boolean throwOnFail) throws MetricNotFoundException, BadlyFormedNameException {
        AgentMetric.AgentMetricKey key = new AgentMetric.AgentMetricKey(metricName, 15);
        AgentMetric result = (AgentMetric)this.fMetricMap.get(key);
        if (result == null && throwOnFail) {
            throw new MetricNotFoundException("Failed to find metric: " + metricName);
        }
        return result;
    }

    @Override
    public AgentMetric[] getAllAgentMetrics() {
        AgentMetric[] result = this.fMetricMap.values().toArray(kZeroLengthAgentMetricArray);
        return result;
    }

    @Override
    public AgentMetric[] getAgentMetrics(IObjectFilter filter) {
        ArrayList<AgentMetric> results = new ArrayList<AgentMetric>(this.fMetricMap.size());
        for (Map.Entry entry : this.fMetricMap.entrySet()) {
            AgentMetric value = (AgentMetric)entry.getValue();
            if (value == null || !filter.matches(value)) continue;
            results.add(value);
        }
        return results.toArray(kZeroLengthAgentMetricArray);
    }

    @Override
    public void executeOnAllAgentMetrics(IObjectAction action) {
        for (Map.Entry entry : this.fMetricMap.entrySet()) {
            AgentMetric value = (AgentMetric)entry.getValue();
            action.execute(value);
        }
    }

    @Override
    public int getNumberAgentMetrics() {
        return this.fMetricMap.size();
    }

    private AgentMetric removeAgentMetric(AgentMetric.AgentMetricKey key) {
        AgentMetric metric = (AgentMetric)this.fMetricMap.remove(key);
        if (metric != null) {
            this.fMetricCounter.prev();
            if (fMetricClampStatus == 1) {
                AgentEventPublisher.getInstance(this.fAgent).publishClampEvent(this.fMetricClamp, this.getNumberAgentMetrics(), false);
                fMetricClampStatus = (byte)2;
            }
        }
        return metric;
    }

    @Override
    public AgentMetric removeAgentMetric(String metricName, int metricType) {
        AgentMetric.AgentMetricKey key = new AgentMetric.AgentMetricKey(metricName, metricType);
        return this.removeAgentMetric(key);
    }

    @Override
    public AgentMetric removeAgentMetric(AgentMetric metric) {
        AgentMetric.AgentMetricKey key = new AgentMetric.AgentMetricKey(metric.getAttributeURL(), metric.getAttributeType());
        return this.removeAgentMetric(key);
    }

    @Override
    public void setNotUseThreadLocal() {
    }
}

