/*
 * Decompiled with CFR 0.152.
 */
package com.wily.org.apache.commons.httpclient.protocol;

import com.wily.org.apache.commons.httpclient.ConnectTimeoutException;
import com.wily.org.apache.commons.httpclient.params.HttpConnectionParams;
import com.wily.org.apache.commons.httpclient.protocol.ControllerThreadSocketFactory;
import com.wily.org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import com.wily.org.apache.commons.httpclient.protocol.ReflectionSocketFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class DefaultProtocolSocketFactory
implements ProtocolSocketFactory {
    private static final DefaultProtocolSocketFactory factory = new DefaultProtocolSocketFactory();
    static /* synthetic */ Class class$0;

    static DefaultProtocolSocketFactory getSocketFactory() {
        return factory;
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        return new Socket(host, port, localAddress, localPort);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        if (timeout == 0) {
            return this.createSocket(host, port, localAddress, localPort);
        }
        Socket socket = ReflectionSocketFactory.createSocket("javax.net.SocketFactory", host, port, localAddress, localPort, timeout);
        if (socket == null) {
            socket = ControllerThreadSocketFactory.createSocket(this, host, port, localAddress, localPort, timeout);
        }
        return socket;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return new Socket(host, port);
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            Class<?> clazz = obj.getClass();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("com.wily.org.apache.commons.httpclient.protocol.DefaultProtocolSocketFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.equals(clazz2)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.wily.org.apache.commons.httpclient.protocol.DefaultProtocolSocketFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.hashCode();
    }
}

