/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.classfile.java;

import com.wily.util.classfile.IPackageName;
import com.wily.util.classfile.IPackagePrefix;
import com.wily.util.classfile.InvalidPackageNameException;
import com.wily.util.classfile.java.PackageName;

public final class PackagePrefix
implements IPackagePrefix {
    private final IPackageName fPackage;
    private final boolean fIncludesTrailingSeparator;

    private PackagePrefix(IPackageName pkg, boolean includesTrailingSeparator) {
        this.fPackage = pkg;
        this.fIncludesTrailingSeparator = includesTrailingSeparator;
    }

    public IPackageName getPackage() {
        return this.getPackageName();
    }

    @Override
    public IPackageName getPackageName() {
        return this.fPackage;
    }

    @Override
    public String getPrefixString() {
        if (this.includesTrailingSeparator()) {
            return String.valueOf(this.getPackageName().getNameString()) + "/";
        }
        return this.getPackageName().getNameString();
    }

    public boolean includesTrailingSeparator() {
        return this.fIncludesTrailingSeparator;
    }

    public String toString() {
        return this.getPrefixString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PackagePrefix) {
            PackagePrefix prefix = (PackagePrefix)obj;
            return this.getPackageName().equals(prefix.getPackageName()) && this.includesTrailingSeparator() == prefix.includesTrailingSeparator();
        }
        return false;
    }

    public int hashCode() {
        return this.getPackageName().hashCode();
    }

    public static PackagePrefix getPackagePrefix(String prefix) throws InvalidPackageNameException {
        String corePackage = prefix;
        boolean endsWithSeparator = false;
        if (corePackage.endsWith(".") || corePackage.endsWith("/")) {
            corePackage = corePackage.substring(0, corePackage.length() - 1);
            endsWithSeparator = true;
        }
        PackageName name = PackageName.getNonDefaultPackageName(corePackage);
        return new PackagePrefix(name, endsWithSeparator);
    }
}

