/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.agent.trace.intelligent.SustainabilityMetricsHelper;
import com.wily.introscope.agent.urlgroup.URLComponents;
import com.wily.introscope.agent.urlgroup.URLGroupRuleContainer;
import com.wily.introscope.agent.urlgroup.URLMatchResult;
import com.wily.util.IConfigurationListener;
import com.wily.util.adt.IConcurrentMap;
import com.wily.util.adt.IGuaranteedCounter;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;

public class FrontendURLGroupingHelper {
    private static volatile boolean urlGroupsInitialized;
    private static final String URL_GROUP_PREFIX = "introscope.agent.urlgroup";
    private static final String URL_GROUP_KEYS_KEY = "introscope.agent.urlgroup.keys";
    private static final String URL_GROUP_KEY_PREFIX = "introscope.agent.urlgroup.group.";
    private static final String URL_GROUP_PATH_PREFIX_SUFFIX = ".pathprefix";
    private static final String URL_GROUP_FORMAT_SUFFIX = ".format";
    private static final String URL_GROUP_CHARENCODING_SUFFIX = ".charEncoding";
    private static volatile URLGroupRuleContainer ruleContainer;
    private static volatile IndexedProperties indexedProperties;
    private static final Module module;
    private final IConcurrentMap frontendUrlGroupMap;
    private final IGuaranteedCounter frontendUrlCounter;
    private static volatile IAgent fAgent;
    private volatile int frontendURLClamp = -1;
    private static volatile ArrayList<String> fFrontendUrlResourcesList;
    private static volatile String userConfiguredAppName;
    private static URLConfigurationListener configListener;
    private static final AtomicReference<FrontendURLGroupingHelper> urlGroupPropertyHelperRef;
    private static volatile FrontendURLGroupingHelper instance;

    static {
        module = new Module("FrontendURLGroupingHelper");
        fFrontendUrlResourcesList = new ArrayList();
        userConfiguredAppName = null;
        urlGroupPropertyHelperRef = new AtomicReference();
    }

    private FrontendURLGroupingHelper(IAgent agent) {
        fAgent = agent;
        indexedProperties = agent.IAgent_getIndexedProperties();
        IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
        IStringLocalizer localizer = agent.IAgent_getStringLocalizer();
        ConfigurationManager cm = agent.IAgent_getConfigurationManager();
        this.frontendUrlGroupMap = (IConcurrentMap)agent.IAgent_getConcurrentMapFactory().getConcurrentMap("FrontendUrlGroups");
        this.frontendUrlCounter = agent.IAgent_getGuaranteedCounter();
        cm.add(new ConfigurationProperty("introscope.agent.urlgroup.frontend.url.clamp", (Object)"20", "Hot_Property_Configuration_Property", null, true, false, feedback, module, localizer){

            @Override
            public final void set(Object value) {
                if (value instanceof String && ((String)value).length() > 0) {
                    FrontendURLGroupingHelper.this.frontendURLClamp = Integer.parseInt((String)value);
                }
            }
        });
        cm.add(new ConfigurationProperty("introscope.agent.urlgroup.frontend.url.resources.list", (Object)"", "Hot_Property_Configuration_Property", null, true, false, feedback, module, localizer){

            @Override
            public final void set(Object value) {
                if (value != null) {
                    fFrontendUrlResourcesList = new ArrayList<String>(Arrays.asList(((String)value).split(",")));
                }
            }
        });
        cm.add(new ConfigurationProperty("introscope.agent.application.name", (Object)"", "Hot_Property_Configuration_Property", null, true, false, feedback, module, localizer){

            @Override
            public final void set(Object value) {
                if (value instanceof String && ((String)value).length() > 0) {
                    userConfiguredAppName = (String)value;
                }
            }
        });
        FrontendURLGroupingHelper.initializeURLGroups(indexedProperties, fAgent.IAgent_getModuleFeedback(), false);
    }

    public static FrontendURLGroupingHelper getInstance() {
        return instance;
    }

    public static void initializeFrontendURLGroupingHelper(IAgent agent) {
        if (urlGroupPropertyHelperRef.get() == null && urlGroupPropertyHelperRef.compareAndSet(null, new FrontendURLGroupingHelper(agent))) {
            instance = urlGroupPropertyHelperRef.get();
        }
    }

    private static void initializeURLGroups(IndexedProperties props, IModuleFeedbackChannel feedback, boolean force) {
        if (!force && urlGroupsInitialized) {
            return;
        }
        if (!urlGroupsInitialized) {
            configListener = new URLConfigurationListener(feedback);
            fAgent.addConfigurationListener(configListener);
        }
        try {
            URLGroupRuleContainer container = new URLGroupRuleContainer();
            String keys = props.getProperty(URL_GROUP_KEYS_KEY);
            if (keys != null && keys.length() > 0) {
                StringTokenizer strtok = new StringTokenizer(keys, ",", false);
                while (strtok.hasMoreTokens()) {
                    String currentKey = strtok.nextToken();
                    String propPrefix = URL_GROUP_KEY_PREFIX + currentKey;
                    String prefixPropKey = String.valueOf(propPrefix) + URL_GROUP_PATH_PREFIX_SUFFIX;
                    String formatPropKey = String.valueOf(propPrefix) + URL_GROUP_FORMAT_SUFFIX;
                    String charEncodingPropKey = String.valueOf(propPrefix) + URL_GROUP_CHARENCODING_SUFFIX;
                    String currentPathPrefix = props.getProperty(prefixPropKey);
                    String currentFormat = null;
                    String currentCharEncoding = null;
                    if (currentPathPrefix != null && currentPathPrefix.length() > 0) {
                        currentFormat = props.getProperty(formatPropKey);
                        if (currentFormat != null && currentFormat.length() > 0) {
                            currentCharEncoding = props.getProperty(charEncodingPropKey);
                            if (feedback.isDebugEnabled()) {
                                feedback.debug(module, "initializeURLGroups: Added url group: " + currentPathPrefix + ", " + currentFormat + ", " + currentCharEncoding);
                            }
                            container.add(currentPathPrefix, currentFormat, currentCharEncoding);
                            continue;
                        }
                        feedback.warn(module, "Mis-configured agent properties: " + currentPathPrefix + ", " + currentFormat + " (both must be non-null and non-empty)");
                        continue;
                    }
                    feedback.warn(module, "Mis-configured agent properties: " + currentPathPrefix + " -- it must be non-null and non-empty");
                }
                ruleContainer = container;
            }
        }
        catch (Exception e) {
            feedback.error("FrontendURLGroupingHelper: Could not initialize URL groupings", e);
        }
        urlGroupsInitialized = true;
    }

    public int getRuleContainerSize() {
        if (ruleContainer != null) {
            return ruleContainer.size();
        }
        return 0;
    }

    public boolean hasQueryParams() {
        if (ruleContainer != null) {
            return ruleContainer.hasQueryParams();
        }
        return false;
    }

    public String getUserConfiuguredAppName() {
        return userConfiguredAppName;
    }

    public URLMatchResult matchFirstRule(URLComponents comps) {
        return ruleContainer.matchFirstRule(comps, fFrontendUrlResourcesList);
    }

    public boolean RuleContainerIsNotDefault() {
        return ruleContainer == null || ruleContainer.isNotDefault();
    }

    public int getFrontendURLGroupClampValue() {
        return this.frontendURLClamp;
    }

    public String applyURLGroupClamp(String normalizedUrl, IModuleFeedbackChannel feedback) {
        if (this.frontendURLClamp >= 0) {
            String result = normalizedUrl;
            String urlGroupKey = "";
            if (result.equals("Resources")) {
                return result;
            }
            if (this.frontendUrlGroupMap.containsKey(result)) {
                return result;
            }
            if (!this.checkUrlGroupClamp(feedback)) {
                result = "Default";
                return result;
            }
            urlGroupKey = (String)this.frontendUrlGroupMap.putIfAbsent(result, "");
            if (urlGroupKey != null) {
                this.frontendUrlCounter.prev();
            } else {
                SustainabilityMetricsHelper.reportFrontendURLGroupsMatched(this.frontendUrlCounter.peek());
            }
            return result;
        }
        return normalizedUrl;
    }

    private boolean checkUrlGroupClamp(IModuleFeedbackChannel feedback) {
        int urlCount;
        if (this.frontendURLClamp >= 0 && (urlCount = this.frontendUrlCounter.next()) >= this.frontendURLClamp) {
            if (urlCount == this.frontendURLClamp) {
                feedback.info("Absolute URL metric clamp of " + this.frontendURLClamp + " reached, All metics will now report under the Default group.");
                return true;
            }
            this.frontendUrlCounter.prev();
            return false;
        }
        return true;
    }

    private static class URLConfigurationListener
    implements IConfigurationListener {
        private IModuleFeedbackChannel feedback;

        private URLConfigurationListener(IModuleFeedbackChannel feedback) {
            this.feedback = feedback;
        }

        @Override
        public void onChange(IndexedProperties props) {
            boolean hasChanged = this.checkForChange(indexedProperties, props);
            if (!hasChanged) {
                hasChanged = this.checkForChange(props, indexedProperties);
            }
            if (hasChanged) {
                boolean wasDefault = ruleContainer == null || !ruleContainer.isNotDefault();
                FrontendURLGroupingHelper.initializeURLGroups(props, this.feedback, true);
                if (wasDefault) {
                    WilyTransactionStructure.getInstance().ageAllImmediately();
                }
            }
            FrontendURLGroupingHelper.indexedProperties = props;
        }

        private boolean checkForChange(IndexedProperties props1, IndexedProperties props2) {
            Enumeration<?> eGlue = props1.propertyNames();
            while (eGlue.hasMoreElements()) {
                String key = (String)eGlue.nextElement();
                if (key.indexOf(FrontendURLGroupingHelper.URL_GROUP_PREFIX) < 0) continue;
                String key1Value = props1.getTrimmedProperty(key);
                String key2Value = props2.getTrimmedProperty(key);
                if (key1Value != null) {
                    if (key1Value.equals(key2Value)) continue;
                    fAgent.IAgent_getModuleFeedback().info("Url grouping: properties have changed, groups will be re-initialized");
                    return true;
                }
                if (key2Value == null) continue;
                fAgent.IAgent_getModuleFeedback().info("Url grouping: properties have changed, groups will be re-initialized");
                return true;
            }
            return false;
        }
    }
}

