/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.properties.hot;

import com.ca.apm.agentmgr.core.result.PropertyAgentMgrResult;
import com.wily.util.IComparer;
import com.wily.util.IConfigurationListener;
import com.wily.util.Sorter;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.SeverityLevel;
import com.wily.util.properties.EnvironmentPropertiesHandler;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.properties.hot.BasicPropertyGroupChangeHelper;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationPropertySet;
import com.wily.util.properties.hot.PropertyGroupChangeHelper;
import com.wily.util.properties.hot.PropertyGroupListner;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ConfigurationManager
implements PropertyGroupChangeHelper,
IConfigurationListener {
    private final IModuleFeedbackChannel feedback;
    private final IStringLocalizer localizer;
    private final Map configurationProperties = new HashMap();
    private final Set configurationPropertySets = new HashSet();
    private final Properties rawProperties = new Properties();
    private final PropertyGroupChangeHelper propertyGroupHandler;
    private static Map envMap = new HashMap();

    public ConfigurationManager(IModuleFeedbackChannel feedback, IStringLocalizer localizer, IndexedProperties initialProps) {
        if (feedback == null || localizer == null) {
            throw new NullPointerException();
        }
        this.feedback = feedback;
        this.localizer = localizer;
        this.propertyGroupHandler = new BasicPropertyGroupChangeHelper(initialProps);
        this.saveRawProperies(initialProps);
        EnvironmentPropertiesHandler instance = EnvironmentPropertiesHandler.getInstance();
        envMap = instance.getEnvMap();
        if (!envMap.isEmpty()) {
            feedback.info("Environment properties: " + envMap.toString());
        }
    }

    public final void add(ConfigurationProperty cp) {
        this.add(cp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(ConfigurationProperty cp, boolean initialize) {
        if (cp == null) {
            return;
        }
        boolean initializeValue = false;
        ConfigurationManager configurationManager = this;
        synchronized (configurationManager) {
            String name = cp.getName();
            if (this.configurationProperties.containsKey(name)) {
                if (!cp.equals(this.configurationProperties.get(name))) {
                    Assertion.wilyAssert("Attempt to add duplicate ConfigurationProperty for '" + name + "'");
                }
            } else {
                this.configurationProperties.put(name, cp);
            }
            if (initialize && this.processProperty(cp, this.rawProperties, true) && !cp.isFixed()) {
                initializeValue = true;
            }
        }
        if (initializeValue) {
            cp.setValueAndLog();
        }
    }

    public final synchronized void add(ConfigurationPropertySet cps, boolean initialize) {
        if (cps == null) {
            return;
        }
        if (this.configurationPropertySets.contains(cps)) {
            return;
        }
        this.configurationPropertySets.add(cps);
        Iterator i = cps.iterator();
        while (i.hasNext()) {
            this.add((ConfigurationProperty)i.next(), false);
        }
        if (initialize) {
            this.processConfiguration(this.rawProperties, true);
        }
    }

    public final synchronized void remove(ConfigurationProperty cp) {
        if (cp == null) {
            return;
        }
        String name = cp.getName();
        this.configurationProperties.remove(name);
    }

    public final synchronized void remove(ConfigurationPropertySet cps, boolean removeConfigurationProperties) {
        if (cps == null) {
            return;
        }
        this.configurationPropertySets.remove(cps);
        if (removeConfigurationProperties) {
            Iterator i = cps.iterator();
            while (i.hasNext()) {
                this.remove((ConfigurationProperty)i.next());
            }
        }
    }

    public final synchronized void setDefaultValue(String name, Object newDefaultValue) {
        ConfigurationProperty cp = (ConfigurationProperty)this.configurationProperties.get(name);
        if (cp != null) {
            cp.setDefaultValue(newDefaultValue);
        } else {
            Assertion.wilyAssert("setDefaultValue ignored: property '" + name + "' not found");
        }
    }

    @Override
    public final synchronized void onChange(IndexedProperties newProps) {
        HashMap<Object, Object> currentProps = new HashMap<Object, Object>();
        currentProps.putAll(newProps);
        if (!envMap.isEmpty()) {
            currentProps.putAll(envMap);
            newProps.putAll((Map<?, ?>)envMap);
        }
        this.processConfiguration(currentProps, false);
        this.saveRawProperies(newProps);
        this.propertyGroupHandler.onChange(newProps);
    }

    private final void processConfiguration(Map newProps, boolean initialize) {
        HashMap candidateProperties = new HashMap(this.configurationProperties);
        HashSet candidatePropertySets = new HashSet(this.configurationPropertySets);
        Map rejectedProperties = this.processProperties(candidateProperties, newProps);
        this.processPropertySets(candidatePropertySets, candidateProperties, rejectedProperties);
        this.setProperties(candidateProperties);
        if (initialize) {
            this.setPropertiesToDefault(rejectedProperties);
        }
        this.setPropertySets(candidatePropertySets);
    }

    private final Map processProperties(Map candidateProperties, Map newProps) {
        Iterator i = candidateProperties.values().iterator();
        HashMap<String, ConfigurationProperty> result = new HashMap<String, ConfigurationProperty>();
        while (i.hasNext()) {
            ConfigurationProperty cp = (ConfigurationProperty)i.next();
            if (this.processProperty(cp, newProps, false)) continue;
            i.remove();
            result.put(cp.getName(), cp);
        }
        return result;
    }

    private final boolean processProperty(ConfigurationProperty cp, Map newProps, boolean useDefaultOnError) {
        return cp.isIndexed() ? this.processIndexedProperty(cp, newProps, useDefaultOnError) : this.processSimpleProperty(cp, newProps, useDefaultOnError);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean processSimpleProperty(ConfigurationProperty cp, Map newProps, boolean useDefaultOnError) {
        String name = cp.getName();
        String rawValue = (String)newProps.get(name);
        boolean setToDefault = false;
        if (newProps.containsKey(name)) {
            Object newValue;
            block6: {
                newValue = cp.convert(rawValue);
                if (newValue == null && !cp.isNullValid()) {
                    if (cp.isSilent()) return this.setNewValueToDefault(cp, useDefaultOnError, setToDefault);
                    this.log(SeverityLevel.WARN, cp, "Hot_Property_Invalid_Message", null, cp.toString(rawValue));
                    return this.setNewValueToDefault(cp, useDefaultOnError, setToDefault);
                }
                if (!cp.isInitialized() || !cp.valueEquals(newValue)) break block6;
                return true;
            }
            try {
                if (cp.isInitialized() && !this.isChangeAllowed(cp, newValue)) return true;
                cp.setInitValue(newValue);
                if (!this.isPropertyChangeValid(cp, newValue)) return this.setNewValueToDefault(cp, useDefaultOnError, setToDefault);
                cp.setNewValue(newValue);
                return true;
            }
            catch (IllegalArgumentException e) {
                if (cp.isSilent()) return this.setNewValueToDefault(cp, useDefaultOnError, setToDefault);
                this.log(SeverityLevel.WARN, cp, "Hot_Property_Invalid_Message", e.getMessage(), cp.toString(rawValue));
                return this.setNewValueToDefault(cp, useDefaultOnError, setToDefault);
            }
            catch (NullPointerException e) {
                if (cp.isSilent()) return this.setNewValueToDefault(cp, useDefaultOnError, setToDefault);
                this.log(SeverityLevel.WARN, cp, "Hot_Property_Invalid_Message", e.getMessage(), cp.toString(rawValue));
                return this.setNewValueToDefault(cp, useDefaultOnError, setToDefault);
            }
        }
        setToDefault = this.shouldSetToDefault(cp);
        return this.setNewValueToDefault(cp, useDefaultOnError, setToDefault);
    }

    private final boolean processIndexedProperty(ConfigurationProperty cp, Map newProps, boolean useDefaultOnError) {
        String namePrefix = String.valueOf(cp.getName()) + ".";
        int namePrefixLength = namePrefix.length();
        boolean propertyOK = true;
        boolean propertyValuesFound = false;
        boolean setToDefault = false;
        ArrayList<IndexedValue> indexedValues = new ArrayList<IndexedValue>();
        for (String propName : newProps.keySet()) {
            int index;
            String rawValue;
            boolean valueOK;
            block12: {
                if (!propName.startsWith(namePrefix)) continue;
                valueOK = true;
                propertyValuesFound = true;
                rawValue = (String)newProps.get(propName);
                index = 0;
                try {
                    index = Integer.parseInt(propName.substring(namePrefixLength));
                }
                catch (NumberFormatException numberFormatException) {
                    valueOK = false;
                    propertyOK = false;
                    if (cp.isSilent()) break block12;
                    String msg = this.localizer.IStringLocalizer_getFormattedLocalizedString("Hot_Property_Invalid_Indexed_Property_Name_Message", propName, rawValue);
                    this.feedback.log(SeverityLevel.WARN, msg);
                }
            }
            if (!valueOK) continue;
            try {
                Object newValue = cp.convert(rawValue);
                if (newValue == null && !cp.isNullValid()) {
                    propertyOK = false;
                    if (cp.isSilent()) continue;
                    this.log(SeverityLevel.WARN, cp, propName, "Hot_Property_Invalid_Message", null, cp.toString(rawValue));
                    continue;
                }
                indexedValues.add(new IndexedValue(index, newValue));
            }
            catch (NumberFormatException e) {
                propertyOK = false;
                if (cp.isSilent()) continue;
                this.log(SeverityLevel.WARN, cp, propName, "Hot_Property_Invalid_Message", e.getMessage(), cp.toString(rawValue));
            }
            catch (IllegalArgumentException e) {
                propertyOK = false;
                if (cp.isSilent()) continue;
                this.log(SeverityLevel.WARN, cp, propName, "Hot_Property_Invalid_Message", e.getMessage(), cp.toString(rawValue));
            }
            catch (NullPointerException e) {
                propertyOK = false;
                if (cp.isSilent()) continue;
                this.log(SeverityLevel.WARN, cp, propName, "Hot_Property_Invalid_Message", e.getMessage(), cp.toString(rawValue));
            }
        }
        if (propertyOK) {
            Object[] indexedValuesArray = indexedValues.toArray(new IndexedValue[0]);
            Sorter.sort(indexedValuesArray, (IComparer)new IndexedValueComparer());
            ArrayList<Object> newValues = new ArrayList<Object>(indexedValuesArray.length);
            int p = 0;
            while (p < indexedValuesArray.length) {
                newValues.add(((IndexedValue)indexedValuesArray[p]).value);
                ++p;
            }
            if ((!cp.isInitialized() || this.isChangeAllowed(cp, newValues)) && this.isPropertyChangeValid(cp, newValues)) {
                cp.setNewValue(newValues);
                return true;
            }
        }
        if (!propertyValuesFound) {
            setToDefault = this.shouldSetToDefault(cp);
        }
        return this.setNewValueToDefault(cp, useDefaultOnError, setToDefault);
    }

    private final boolean shouldSetToDefault(ConfigurationProperty cp) {
        return !cp.isInitialized() || !cp.valueEquals(cp.getDefaultValue()) && this.isChangeAllowed(cp, cp.getDefaultValue());
    }

    private final boolean setNewValueToDefault(ConfigurationProperty cp, boolean useDefaultOnError, boolean setToDefault) {
        Object defaultValue = cp.getDefaultValue();
        if (cp.isInitialized() && cp.valueEquals(defaultValue)) {
            return true;
        }
        if ((!cp.isInitialized() && useDefaultOnError || setToDefault) && this.isPropertyChangeValid(cp, defaultValue)) {
            cp.setNewValueToDefault();
            return true;
        }
        return false;
    }

    private final boolean isPropertyChangeValid(ConfigurationProperty cp, Object newValue) {
        boolean changeValid = false;
        if (this.isChangeAllowed(cp, newValue)) {
            String detail = null;
            try {
                changeValid = cp.validate(newValue);
            }
            catch (IllegalArgumentException e) {
                detail = e.getMessage();
            }
            catch (NullPointerException e) {
                detail = e.getMessage();
            }
            if (!changeValid && !cp.isSilent()) {
                this.log(SeverityLevel.WARN, cp, "Hot_Property_Invalid_Message", detail == null ? "" : detail, cp.toString(newValue));
            }
        }
        return changeValid;
    }

    private final boolean isChangeAllowed(ConfigurationProperty cp, Object newValue) {
        if (!cp.isInitialized()) {
            return true;
        }
        if (cp.isFixed()) {
            if (!cp.isSilent()) {
                this.log(SeverityLevel.WARN, cp, "Hot_Property_Fixed_Change_Attempt_Message", null, cp.toString(newValue));
            }
            return false;
        }
        if (!cp.isHot()) {
            if (!cp.isSilent() && !cp.isInitValue(newValue)) {
                this.log(SeverityLevel.WARN, cp, "Not_Hot_Property_Change_Attempt_Message", null, cp.toString(newValue));
            }
            return false;
        }
        return true;
    }

    private final void processPropertySets(Set candidatePropertySets, Map candidateProperties, Map rejectedProperties) {
        Iterator i = candidatePropertySets.iterator();
        while (i.hasNext()) {
            ConfigurationPropertySet cps = (ConfigurationPropertySet)i.next();
            boolean setOK = true;
            boolean setAffected = false;
            Iterator cpi = cps.iterator();
            while (cpi.hasNext() && setOK) {
                ConfigurationProperty cp = (ConfigurationProperty)cpi.next();
                String propName = cp.getName();
                if (rejectedProperties.containsKey(propName)) {
                    if (!cps.rejectValidPropertyChangesWhenSetRejected()) continue;
                    i.remove();
                    this.rejectSet(cps, SeverityLevel.WARN, "Hot_Property_Prop_Failed_Reject_Others", propName, candidateProperties, rejectedProperties);
                    setOK = false;
                    continue;
                }
                if (!candidateProperties.containsKey(propName)) continue;
                setAffected = true;
            }
            if (!setOK) continue;
            if (setAffected) {
                boolean setValid = false;
                String detail = null;
                try {
                    setValid = cps.validate();
                }
                catch (IllegalArgumentException e) {
                    detail = e.getMessage();
                }
                if (setValid) continue;
                i.remove();
                String msgKey = StringUtils.isEmpty(detail) ? "Hot_Property_Set_Validate_Failed_No_Detail_Message" : "Hot_Property_Set_Validate_Failed_With_Detail_Message";
                this.rejectSet(cps, SeverityLevel.WARN, msgKey, detail, candidateProperties, rejectedProperties);
                continue;
            }
            i.remove();
        }
    }

    private final void rejectSet(ConfigurationPropertySet cps, SeverityLevel severity, String errMsg, String reason, Map candidateProperties, Map rejectedProperties) {
        Iterator cpi = cps.iterator();
        int nIgnored = 0;
        StringBuilder ignoredNames = new StringBuilder();
        String sep = "";
        while (cpi.hasNext()) {
            ConfigurationProperty cp = (ConfigurationProperty)cpi.next();
            String name = cp.getName();
            if (candidateProperties.remove(name) != null) {
                ++nIgnored;
                ignoredNames.append(sep);
                sep = ",";
                ignoredNames.append(name);
            }
            rejectedProperties.put(cp.getName(), cp);
        }
        this.log(severity, errMsg, reason, nIgnored == 1 ? "Hot_Property_Singular" : "Hot_Property_Plural", ignoredNames.toString());
    }

    private final void setProperties(Map candidateProperties) {
        for (ConfigurationProperty cp : candidateProperties.values()) {
            if (cp.isInitialized() && cp.valueEquals(cp.getNewValue()) || cp.isFixed()) continue;
            cp.setValueAndLog();
        }
    }

    private final void setPropertiesToDefault(Map candidateProperties) {
        for (ConfigurationProperty cp : candidateProperties.values()) {
            cp.setNewValueToDefault();
            cp.setValueAndLog();
        }
    }

    private final void setPropertySets(Set candidatePropertySets) {
        for (ConfigurationPropertySet cps : candidatePropertySets) {
            cps.set();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveRawProperies(Map newProps) {
        Properties properties = this.rawProperties;
        synchronized (properties) {
            this.rawProperties.clear();
            if (newProps != null) {
                this.rawProperties.putAll((Map<?, ?>)newProps);
            }
        }
    }

    private final void log(SeverityLevel level, ConfigurationProperty cp, String messageKey, String reason, String value) {
        String msg = cp.formatLocalizedMessage(messageKey, StringUtils.isEmpty(reason) ? "" : reason, value);
        this.feedback.log(level, msg);
    }

    private final void log(SeverityLevel level, ConfigurationProperty cp, String propName, String messageKey, String reason, String value) {
        String msg = cp.formatLocalizedMessage(propName, messageKey, StringUtils.isEmpty(reason) ? "" : reason, value);
        this.feedback.log(level, msg);
    }

    private final void log(SeverityLevel level, String messageKey, String reason, String propsKey, String propNames) {
        String props = this.localizer.IStringLocalizer_getLocalizedString(propsKey);
        String msg = this.localizer.IStringLocalizer_getFormattedLocalizedString(messageKey, StringUtils.isEmpty(reason) ? "" : reason, props, propNames);
        this.feedback.log(level, msg);
    }

    public Map getProperties() {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        for (Map.Entry<Object, Object> currVal : this.rawProperties.entrySet()) {
            result.put(currVal.getKey(), currVal.getValue());
        }
        return result;
    }

    public String getProperty(String propName) {
        return this.rawProperties.getProperty(propName);
    }

    public final synchronized Map onChange(Map newProps, boolean batchProcess, String agentName, int resultType) {
        HashMap<Object, PropertyAgentMgrResult> propertiesCallBackResult = new HashMap<Object, PropertyAgentMgrResult>();
        new HashMap();
        new HashMap();
        PropertyAgentMgrResult propertyResult = new PropertyAgentMgrResult(agentName, 90, resultType);
        for (Map.Entry prop : newProps.entrySet()) {
            String propName = (String)prop.getKey();
            String propValue = (String)prop.getValue();
            if (!batchProcess) {
                propertyResult = new PropertyAgentMgrResult(agentName, 90, resultType);
            }
            propertyResult.addProperty(propName, propValue);
            if (this.rawProperties.containsKey(propName)) {
                this.rawProperties.put(propName, propValue);
                if (batchProcess) {
                    propertiesCallBackResult.put(newProps, propertyResult);
                    return propertiesCallBackResult;
                }
            } else {
                propertyResult.setStatus(107);
                propertyResult.setVerboseCause("Hot_Property_Not_Exist");
                if (batchProcess) {
                    propertiesCallBackResult.put(newProps, propertyResult);
                    return propertiesCallBackResult;
                }
            }
            if (batchProcess) {
                propertiesCallBackResult.put(newProps, propertyResult);
                continue;
            }
            propertiesCallBackResult.put(propName, propertyResult);
        }
        return propertiesCallBackResult;
    }

    @Override
    public boolean registerListener(PropertyGroupListner listener) {
        return this.propertyGroupHandler.registerListener(listener);
    }

    @Override
    public boolean removeListener(PropertyGroupListner listener) {
        return this.propertyGroupHandler.removeListener(listener);
    }

    private class IndexedValue {
        public final int index;
        public final Object value;

        private IndexedValue(int index, Object value) {
            this.index = index;
            this.value = value;
        }
    }

    private class IndexedValueComparer
    implements IComparer {
        private IndexedValueComparer() {
        }

        @Override
        public boolean lessThan(Object obj1, Object obj2) {
            return ((IndexedValue)obj1).index < ((IndexedValue)obj2).index;
        }

        @Override
        public boolean equalTo(Object obj1, Object obj2) {
            return ((IndexedValue)obj1).index == ((IndexedValue)obj2).index;
        }
    }
}

