/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.properties.lockable;

import com.wily.util.WilyStringBuilder;
import com.wily.util.properties.lockable.ProfileLine;

public class KeyLine
extends ProfileLine {
    private String fKey;
    private boolean fCommented;
    private String fValue;

    public KeyLine(int index, String key, boolean commented, String value) {
        super(index);
        this.fKey = key;
        this.fCommented = commented;
        this.fValue = value;
    }

    public KeyLine(int index, String key, boolean commented) {
        this(index, key, commented, null);
    }

    private String escapeSpecialPropertyFileCharacters(String s) {
        WilyStringBuilder sb = new WilyStringBuilder();
        char[] input = s.toCharArray();
        int i = 0;
        while (i < input.length) {
            if (input[i] == '=' || input[i] == ':' || input[i] == '\\') {
                sb.append('\\');
            }
            sb.append(input[i]);
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String getLine() {
        WilyStringBuilder sb = new WilyStringBuilder(this.isCommented() ? "#" : "");
        sb.append(this.escapeSpecialPropertyFileCharacters(this.fKey)).append("=");
        if (this.fValue != null) {
            sb.append(this.escapeSpecialPropertyFileCharacters(this.fValue));
        }
        return sb.toString();
    }

    public String getKey() {
        return this.fKey;
    }

    public boolean isCommented() {
        return this.fCommented;
    }

    @Override
    public boolean isKey() {
        return true;
    }

    public String getValue() {
        return this.fValue;
    }

    public void setCommented(boolean commented) {
        this.fCommented = commented;
    }

    public void setValue(String value) {
        this.fValue = value;
    }
}

