/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.http.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.KMetricNameConstants;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.backend.http.dataresolver.HttpDataResolver;
import com.wily.introscope.agent.trace.backend.http.helper.BackendUrlGroupPropertyHandler;
import com.wily.introscope.agent.trace.backend.http.nameformatter.URINameFormatter;
import com.wily.introscope.agent.trace.backendprotocols.BackendProtocolsConstants;
import com.wily.introscope.agent.trace.utilities.UrlUtilities;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.PropertyGroupListner;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;

public abstract class BaseURINameFormatter
implements URINameFormatter,
BackendProtocolsConstants {
    public static final String[] PLACEHOLDERS = new String[]{"{url}", "{type}", "{protocol}", "{host}", "{port}", "{path}", "{query}", "{httpMethod}", "{methodpath}"};
    public static final String[] UNKNOWN_STRINGS = new String[]{"UnknownUrl", "UnknownType", "UnknownProtocol", "UnknownHost", "UnknownPort", "UnknownPath", "UnknownQuery", "UnknownHttpMethod", "Unknown HttpMethod and Path"};
    public static final String[] INVALID_STRINGS = new String[]{"InvalidUrl", "InvalidType", "InvalidProtocol", "InvalidHost", "InvalidPort", "InvalidPath", "InvalidQuery", "InvalidHttpMethod", "Invalid HttpMethod and Path"};
    protected static final int PLACEHOLDER_URL = 0;
    protected static final int PLACEHOLDER_TYPE = 1;
    protected static final int PLACEHOLDER_PROTOCOL = 2;
    protected static final int PLACEHOLDER_HOST = 3;
    protected static final int PLACEHOLDER_PORT = 4;
    protected static final int PLACEHOLDER_PATH = 5;
    protected static final int PLACEHOLDER_QUERY = 6;
    protected static final int PLACEHOLDER_HTTPMETHOD = 7;
    protected static final int PLACEHOLDER_HTTPMETHODPATH = 8;
    private static final Module module = new Module("BaseURINameFormatter");
    protected IModuleFeedbackChannel feedback;
    protected volatile HttpDataResolver uriResolver;
    private final IAgent agent;
    private static final AtomicReference<BackendUrlGroupPropertyHandler> backendUrlGroupPropertyHandlerHolder = new AtomicReference();
    private static ThreadLocal NameFormatterBuilder = new ThreadLocal(){

        protected Object initialValue() {
            return new StringBuilder();
        }
    };

    private static void setupURLGroupingSettings(IAgent agent) {
        if (backendUrlGroupPropertyHandlerHolder.get() == null && backendUrlGroupPropertyHandlerHolder.compareAndSet(null, new BackendUrlGroupPropertyHandler(agent))) {
            agent.IAgent_getConfigurationManager().registerListener((PropertyGroupListner)backendUrlGroupPropertyHandlerHolder.get());
        }
    }

    public BaseURINameFormatter(IAgent agent) {
        this.agent = agent;
        this.feedback = this.getAgent().IAgent_getModuleFeedback();
        this.uriResolver = this.getURIResolver();
        BaseURINameFormatter.setupURLGroupingSettings(agent);
    }

    protected HttpDataResolver getURIResolver(InvocationData data) {
        if (this.uriResolver != null) {
            return this.uriResolver;
        }
        return this.getURIResolver();
    }

    public String INameFormatter_format(String name, InvocationData data) {
        String result = null;
        this.uriResolver = this.getURIResolver(data);
        if (name != null) {
            try {
                StringBuilder metricBldr = (StringBuilder)NameFormatterBuilder.get();
                metricBldr.replace(0, metricBldr.length(), name);
                int placeholder = 0;
                while (placeholder < PLACEHOLDERS.length) {
                    int index = metricBldr.indexOf(PLACEHOLDERS[placeholder]);
                    if (index >= 0) {
                        switch (placeholder) {
                            case 0: {
                                metricBldr = this.replaceAll(metricBldr, PLACEHOLDERS[placeholder], this.resolveDestination(data));
                                break;
                            }
                            case 1: {
                                metricBldr = this.replaceAll(metricBldr, PLACEHOLDERS[placeholder], this.resolveType(data));
                                break;
                            }
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: {
                                metricBldr = this.replaceAll(metricBldr, PLACEHOLDERS[placeholder], this.resolveURLAttribute(data, placeholder));
                                break;
                            }
                            case 7: {
                                metricBldr = this.replaceAll(metricBldr, PLACEHOLDERS[placeholder], this.resolveHttpMethod(data));
                                break;
                            }
                            case 8: {
                                metricBldr = this.replaceAll(metricBldr, PLACEHOLDERS[placeholder], this.resolveHttpMethodAndPath(data));
                                break;
                            }
                            default: {
                                this.feedback.warn(module, "An unknown name formatter placeholder requested:" + placeholder);
                            }
                        }
                    }
                    ++placeholder;
                }
                result = this.formatToBeResourceSafe(metricBldr).toString();
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    this.feedback.error("An error occurred formatting http client metric name");
                    this.feedback.verbose(t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
            }
        }
        return result;
    }

    protected String resolveType(InvocationData data) {
        String type = (String)data.get("HttpURI.Type.Key");
        if (type == null || type.equals(UNKNOWN_STRINGS[1])) {
            type = this.getType(data);
            if (type == null) {
                type = UNKNOWN_STRINGS[1];
            }
            data.put("HttpURI.Type.Key", (Object)type);
        }
        return type;
    }

    protected String resolveDestination(InvocationData data) {
        String destination = (String)data.get("HttpURI.Url.Key");
        if (destination == null || destination.length() == 0) {
            URI url = this.getURIIntern(data);
            StringBuilder urlBldr = new StringBuilder();
            if (url == BackendProtocolsConstants.UNKNOWN_URI) {
                destination = urlBldr.append(UNKNOWN_STRINGS[2]).append("_//").append(UNKNOWN_STRINGS[3]).append("_").append(UNKNOWN_STRINGS[4]).toString();
            } else {
                urlBldr.append(url.getScheme() == null ? UNKNOWN_STRINGS[2] : url.getScheme()).append("_//").append(url.getHost() == null ? UNKNOWN_STRINGS[3] : url.getHost());
                if (url.getPort() != -1) {
                    urlBldr.append("_").append(url.getPort());
                }
                destination = urlBldr.toString();
            }
            data.put("HttpURI.Url.Key", (Object)destination);
        }
        return destination;
    }

    protected String resolveURLAttribute(InvocationData data, int attribute) {
        String attributeStr = null;
        URI url = this.getURIIntern(data);
        switch (attribute) {
            case 2: {
                if (url != BackendProtocolsConstants.UNKNOWN_URI && url != BackendProtocolsConstants.INVALID_URI) {
                    attributeStr = url.getScheme();
                }
                if (url == BackendProtocolsConstants.INVALID_URI) {
                    attributeStr = INVALID_STRINGS[attribute];
                }
                if (attributeStr != null && attributeStr.length() != 0) break;
                attributeStr = UNKNOWN_STRINGS[attribute];
                break;
            }
            case 3: {
                if (url != BackendProtocolsConstants.UNKNOWN_URI && url != BackendProtocolsConstants.INVALID_URI) {
                    attributeStr = this.getHost(url);
                }
                if (url == BackendProtocolsConstants.INVALID_URI) {
                    attributeStr = INVALID_STRINGS[attribute];
                }
                if (attributeStr != null && attributeStr.length() != 0) break;
                attributeStr = UNKNOWN_STRINGS[attribute];
                break;
            }
            case 4: {
                if (url != BackendProtocolsConstants.UNKNOWN_URI && url != BackendProtocolsConstants.INVALID_URI) {
                    int port = url.getPort();
                    if (port == -1) {
                        attributeStr = url.getScheme();
                        if (attributeStr != null && "http".equals(attributeStr)) {
                            attributeStr = "80";
                            break;
                        }
                        if (attributeStr != null && "https".equals(attributeStr)) {
                            attributeStr = "443";
                            break;
                        }
                        attributeStr = UNKNOWN_STRINGS[attribute];
                        break;
                    }
                    attributeStr = String.valueOf(port);
                    break;
                }
                if (url == BackendProtocolsConstants.INVALID_URI) {
                    attributeStr = INVALID_STRINGS[attribute];
                    break;
                }
                attributeStr = UNKNOWN_STRINGS[attribute];
                break;
            }
            case 5: {
                if (url != BackendProtocolsConstants.UNKNOWN_URI && url != BackendProtocolsConstants.INVALID_URI) {
                    attributeStr = this.getRawPath(url);
                    attributeStr = backendUrlGroupPropertyHandlerHolder.get().getNormalizedPath(attributeStr);
                }
                if (url == BackendProtocolsConstants.INVALID_URI) {
                    attributeStr = (String)data.get("HttpURI.Path.Key.Invalid");
                }
                if (attributeStr != null && attributeStr.length() != 0) break;
                attributeStr = "/";
                break;
            }
            case 6: {
                if (url != BackendProtocolsConstants.UNKNOWN_URI) {
                    attributeStr = this.getRawQuery(url);
                }
                if (attributeStr != null) break;
                attributeStr = "";
                break;
            }
            default: {
                this.feedback.warn(module, "There was an unknown URL part requested:" + attribute);
                attributeStr = "ERROR";
            }
        }
        return attributeStr;
    }

    protected String encodeIfRequired(String attributeStr) {
        return attributeStr;
    }

    protected String getRawPath(URI url) {
        return url.getRawPath();
    }

    protected String getRawQuery(URI url) {
        return url.getRawQuery();
    }

    protected String getHost(URI url) {
        return url.getHost();
    }

    protected String resolveHttpMethod(InvocationData data) {
        String httpMethod = (String)data.get("HttpURI.Method.Key");
        if (httpMethod == null || httpMethod.length() == 0 || httpMethod == "Unknown") {
            httpMethod = this.uriResolver.getHttpMethod(this.agent, data);
            if (httpMethod == null || httpMethod.length() == 0) {
                httpMethod = UNKNOWN_STRINGS[7];
            }
            data.put("HttpURI.Method.Key", (Object)httpMethod);
        }
        return httpMethod;
    }

    protected String resolveHttpMethodAndPath(InvocationData data) {
        String methodPath = (String)data.get("HttpURI.MethodPath.Key");
        if (methodPath == null || methodPath.length() == 0) {
            String path;
            String method = this.resolveHttpMethod(data);
            if (method == null || method.length() == 0) {
                method = UNKNOWN_STRINGS[7];
            }
            if ((path = this.resolveURLAttribute(data, 5)) == null || path.length() == 0) {
                path = UNKNOWN_STRINGS[5];
            }
            methodPath = new StringBuilder(method.length() + path.length() + 1).append(method).append(" ").append(path).toString();
            data.put("HttpURI.MethodPath.Key", (Object)methodPath);
        }
        return methodPath;
    }

    protected URI getURIIntern(InvocationData data) {
        URI uri = (URI)data.get("HttpURI.Key");
        if (uri == null) {
            uri = this.uriResolver.getUri(this.agent, data);
            if (uri == null) {
                uri = BackendProtocolsConstants.UNKNOWN_URI;
            }
            data.put("HttpURI.Key", (Object)uri);
        }
        return uri;
    }

    private StringBuilder formatToBeResourceSafe(StringBuilder builder) {
        return UrlUtilities.replaceAllIllegalChars(builder, KMetricNameConstants.kIllegalResourceChars, '_');
    }

    private StringBuilder replaceAll(StringBuilder builder, String source, String dest) {
        if (builder != null && dest != null) {
            int index = builder.indexOf(source);
            while (index != -1) {
                builder.replace(index, index + source.length(), dest);
                index += dest.length();
                index = builder.indexOf(source, index);
            }
        }
        return builder;
    }

    protected IAgent getAgent() {
        return this.agent;
    }

    protected abstract HttpDataResolver getURIResolver();
}

