/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.autoprobe.dynamic;

import com.wily.diagnos.cmp.classfile.DGClassLoadingException;
import com.wily.diagnos.cmp.classmatcher.IClassMatcher;
import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.diagnos.cmp.tracer.MethodTracer;
import com.wily.diagnos.personality.java.classfile.DGClass;
import com.wily.introscope.agent.util.ByteClassUtil;
import com.wily.introscope.autoprobe.dynamic.FlagMatcher;
import com.wily.introscope.autoprobe.dynamic.MethodMatcherInfo;
import com.wily.introscope.autoprobe.dynamic.NullCompoundClassMatcher;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Util
extends ByteClassUtil {
    public static Map getFlagMatcherMap(DGCompilerSettings compilerSettings) {
        NullCompoundClassMatcher nullClassMatcher = new NullCompoundClassMatcher();
        HashMap<String, FlagMatcher> flagMatcherMap = new HashMap<String, FlagMatcher>();
        flagMatcherMap.put("NULLTracerGroup", new FlagMatcher("NULLTracerGroup", nullClassMatcher, true));
        Iterator settingsItr = compilerSettings.getTracersIterator();
        while (settingsItr.hasNext()) {
            MethodTracer methodTracer = (MethodTracer)settingsItr.next();
            String flag = null;
            if (methodTracer.getTracerGroup() != null) {
                flag = methodTracer.getTracerGroup().getName().getName();
                if (!flagMatcherMap.containsKey(flag)) {
                    flagMatcherMap.put(flag, new FlagMatcher(flag, methodTracer.getClassMatcher(), methodTracer.getTracerGroup().isEnabled()));
                }
            } else {
                flag = "NULLTracerGroup";
                nullClassMatcher.addClassMatcher(methodTracer.getClassMatcher());
            }
            FlagMatcher flagMatcher = (FlagMatcher)flagMatcherMap.get(flag);
            MethodMatcherInfo methodMatcherInfo = new MethodMatcherInfo(methodTracer.getMethodMatcher(), methodTracer.getTracerParameters(), methodTracer.needsParameterAccess(), methodTracer.getTracerClass());
            flagMatcher.addMethodMatcherInfo(methodMatcherInfo);
        }
        return flagMatcherMap;
    }

    public static Set getMatchingFlags(Map flagMatcherMap, IModeledClass modeledClass) {
        HashSet<FlagMatcher> flagMatchers = new HashSet<FlagMatcher>();
        for (String flag : flagMatcherMap.keySet()) {
            FlagMatcher flagMatcher = (FlagMatcher)flagMatcherMap.get(flag);
            if (!flagMatcher.getClassMatcher().IClassMatcher_matches(modeledClass)) continue;
            flagMatchers.add(flagMatcher);
        }
        return flagMatchers;
    }

    public static int getMatchForFlag(String flag, FlagMatcher prevFlagMatcher, FlagMatcher currentFlagMatcher, IModeledClass modeledClass) {
        IClassMatcher currentClassMatcher;
        IClassMatcher prevClassMatcher;
        boolean matchesPrev = false;
        boolean matchesCurrent = false;
        if (prevFlagMatcher != null && (prevClassMatcher = prevFlagMatcher.getClassMatcher()) != null && prevClassMatcher.IClassMatcher_matches(modeledClass)) {
            matchesPrev = true;
        }
        if (currentFlagMatcher != null && (currentClassMatcher = currentFlagMatcher.getClassMatcher()) != null && currentClassMatcher.IClassMatcher_matches(modeledClass)) {
            matchesCurrent = true;
        }
        if (matchesPrev && !matchesCurrent) {
            return 1;
        }
        if (matchesCurrent && !matchesPrev) {
            return 2;
        }
        if (matchesCurrent && matchesPrev) {
            return 3;
        }
        return 0;
    }

    public static boolean shouldSkip(Class cls, DGCompilerSettings settings) {
        if (cls.getClassLoader() == null) {
            return true;
        }
        if (cls.isArray() || cls.isInterface()) {
            return true;
        }
        if (cls.getName().startsWith("java.") || cls.getName().startsWith("com.sun") || cls.getName().startsWith("sun.reflect") || cls.getName().startsWith("$")) {
            return true;
        }
        if (cls.getClassLoader().getClass().getName().startsWith("com.wily")) {
            return true;
        }
        return settings.getFilter().shouldSkip(cls.getName());
    }

    public static Set generateChangedMethodMatcherSet(FlagMatcher previousFlagMatcher, FlagMatcher currentFlagMatcher, boolean isNullGroup) {
        HashSet<IMethodMatcher> changedMethodMatchers = new HashSet<IMethodMatcher>();
        Set prevMethodMatchers = previousFlagMatcher.getClonedMethodMatcherSet();
        Set currentMethodMatchers = currentFlagMatcher.getClonedMethodMatcherSet();
        prevMethodMatchers.removeAll(currentFlagMatcher.getClonedMethodMatcherSet());
        Iterator prevItr = prevMethodMatchers.iterator();
        while (prevItr.hasNext()) {
            changedMethodMatchers.add(((MethodMatcherInfo)prevItr.next()).getMethodMatcher());
        }
        currentMethodMatchers.removeAll(previousFlagMatcher.getClonedMethodMatcherSet());
        Iterator currentItr = currentMethodMatchers.iterator();
        while (currentItr.hasNext()) {
            changedMethodMatchers.add(((MethodMatcherInfo)currentItr.next()).getMethodMatcher());
        }
        return changedMethodMatchers;
    }

    public static Set getClonedKeySet(Map map) {
        HashSet clonedSet = new HashSet();
        clonedSet.addAll(map.keySet());
        return clonedSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DGClass getDGClass(Class cls, int limit, IModuleFeedbackChannel feedback) throws IOException {
        DGClass dGClass;
        byte[] classCode = ByteClassUtil.getBytesForClass((Class)cls, (int)limit, (IModuleFeedbackChannel)feedback);
        if (classCode == null) return null;
        ByteArrayInputStream is = null;
        try {
            DGClass result;
            is = new ByteArrayInputStream(classCode);
            dGClass = result = new DGClass((InputStream)is);
        }
        catch (DGClassLoadingException e) {
            try {
                throw new IOException(e.getMessage());
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            is.close();
            return dGClass;
        }
        catch (Exception exception) {}
        return dGClass;
    }
}

