/*
 * Decompiled with CFR 0.152.
 */
package com.wily.math;

import com.wily.wilyassert.Assertion;
import java.math.BigInteger;
import java.util.Random;

public class RunningLongAverage {
    private static final boolean fSafetyChecksOn = false;
    private long fCount;
    private long fValueHigh;
    private long fValueLow;
    private long fMinimum;
    private long fMaximum;
    private boolean fIsPositive;
    private BigInteger fSafetyCheck;
    private static final BigInteger kBigIntZero = new BigInteger("0");
    private static final BigInteger kBigIntMaxVal = new BigInteger("9223372036854775807");

    public RunningLongAverage() {
        this.initialize();
    }

    private void initialize() {
        this.fCount = 0L;
        this.fValueHigh = 0L;
        this.fValueLow = 0L;
        this.fMinimum = 0L;
        this.fMaximum = 0L;
        this.fIsPositive = true;
        this.fSafetyCheck = kBigIntZero;
    }

    public void reset() {
        this.initialize();
    }

    public static boolean is30BitsOrLess(long val) {
        return val < 0x3FFFFFFFL && val > -1073741824L;
    }

    public void combineValue(long avg, long count, long minimum, long maximum) {
        if (count < 1L) {
            return;
        }
        if (this.fCount == 0L) {
            this.fMinimum = minimum;
            this.fMaximum = maximum;
        } else {
            if (maximum > this.fMaximum) {
                this.fMaximum = maximum;
            }
            if (minimum < this.fMinimum) {
                this.fMinimum = minimum;
            }
        }
        if (RunningLongAverage.is30BitsOrLess(avg) && RunningLongAverage.is30BitsOrLess(count)) {
            this.internalCombineValue(avg * count);
            --this.fCount;
            this.fCount += count;
            this.normalize();
        } else {
            BigInteger me = this.getValue();
            BigInteger him = new BigInteger(String.valueOf(avg));
            him = him.multiply(new BigInteger(String.valueOf(count)));
            BigInteger newTotal = me.add(him);
            this.fCount += count;
            this.setValue(newTotal);
        }
    }

    public void removeValue(long avg, long count, long minimum, long maximum) {
        this.fMinimum = -1L;
        this.fMaximum = -1L;
        BigInteger me = this.getValue();
        BigInteger him = new BigInteger(String.valueOf(avg));
        him = him.multiply(new BigInteger(String.valueOf(count)));
        BigInteger newTotal = me.subtract(him);
        this.fCount -= count;
        this.setValue(newTotal);
    }

    public void removeValueAndKeepTotalCountSame(long avg, long count, long minimum, long maximum) {
        this.fMinimum = -1L;
        this.fMaximum = -1L;
        BigInteger me = this.getValue();
        BigInteger him = new BigInteger(String.valueOf(avg));
        him = him.multiply(new BigInteger(String.valueOf(count)));
        BigInteger newTotal = me.subtract(him);
        this.setValue(newTotal);
    }

    private void normalize() {
        if (this.fValueHigh == 0L && this.fValueLow == 0L && !this.fIsPositive) {
            this.fIsPositive = true;
        }
        Assertion.wilyAssert(this.fValueHigh >= 0L);
        Assertion.wilyAssert(this.fValueLow >= 0L);
        Assertion.wilyAssert(this.fCount >= 0L);
    }

    public void combineValue(long newVal) {
        if (this.fCount == 0L) {
            this.fMinimum = this.fMaximum = newVal;
        } else {
            if (newVal > this.fMaximum) {
                this.fMaximum = newVal;
            }
            if (newVal < this.fMinimum) {
                this.fMinimum = newVal;
            }
        }
        this.internalCombineValue(newVal);
    }

    private void internalCombineValue(long newVal) {
        if (newVal == 0L) {
            ++this.fCount;
            this.normalize();
            return;
        }
        if (this.fIsPositive) {
            if (newVal >= 0L) {
                this.fValueLow += newVal;
                if (this.fValueLow < 0L) {
                    this.incrementHigh();
                    this.fValueLow = this.fValueLow - Long.MIN_VALUE + 1L;
                }
            } else {
                long oldLow = this.fValueLow;
                this.fValueLow += newVal;
                if (this.fValueLow < 0L) {
                    if (this.decrementHigh()) {
                        this.fValueLow = Long.MAX_VALUE + this.fValueLow;
                    } else {
                        this.fValueLow = -newVal - oldLow;
                        if (this.fValueLow < 0L) {
                            this.decrementHigh();
                            this.fValueLow = 1L;
                        }
                    }
                }
            }
        } else if (newVal >= 0L) {
            long oldLow = this.fValueLow;
            this.fValueLow -= newVal;
            if (this.fValueLow < 0L) {
                this.fValueLow = this.incrementHigh() ? (this.fValueLow += Long.MAX_VALUE) : newVal - oldLow;
            }
        } else {
            this.fValueLow -= newVal;
            if (this.fValueLow < 0L) {
                this.decrementHigh();
                this.fValueLow = this.fValueLow - Long.MIN_VALUE + 1L;
            }
        }
        ++this.fCount;
        this.normalize();
    }

    public long getCount() {
        return this.fCount;
    }

    private BigInteger getValue() {
        BigInteger high = new BigInteger(String.valueOf(this.fValueHigh));
        BigInteger low = new BigInteger(String.valueOf(this.fValueLow));
        BigInteger answer = kBigIntZero;
        if (this.fIsPositive) {
            answer = answer.add(low);
            BigInteger highSum = kBigIntMaxVal.multiply(high);
            answer = answer.add(highSum);
        } else {
            answer = answer.subtract(low);
            BigInteger highSum = kBigIntMaxVal.multiply(high);
            answer = answer.subtract(highSum);
        }
        return answer;
    }

    private void setValue(BigInteger val) {
        int sign = val.signum();
        BigInteger temp = val;
        if (sign == 0) {
            this.fIsPositive = true;
            this.fValueLow = 0L;
            this.fValueHigh = 0L;
            return;
        }
        if (sign > 0) {
            this.fIsPositive = true;
        } else {
            this.fIsPositive = false;
            temp = val.negate();
        }
        BigInteger high = temp.divide(kBigIntMaxVal);
        BigInteger difference = temp.subtract(high.multiply(kBigIntMaxVal));
        this.fValueHigh = high.longValue();
        this.fValueLow = difference.longValue();
        this.normalize();
    }

    public long getAverage() {
        if (this.fCount == 0L) {
            return 0L;
        }
        if (this.fValueHigh == 0L) {
            if (this.fIsPositive) {
                return this.fValueLow / this.fCount;
            }
            return -this.fValueLow / this.fCount;
        }
        return this.getSafeAverage();
    }

    public long getSafeAverage() {
        BigInteger meVal = this.getValue();
        BigInteger countVal = new BigInteger(String.valueOf(this.fCount));
        BigInteger answer = meVal.divide(countVal);
        return answer.longValue();
    }

    public long getMinimum() {
        return this.fMinimum;
    }

    public long getMaximum() {
        return this.fMaximum;
    }

    public String toString() {
        return "" + this.getAverage();
    }

    public String toDebugString() {
        return "pos=" + this.fIsPositive + "  high=" + this.fValueHigh + "  low=" + this.fValueLow;
    }

    private boolean incrementHigh() {
        if (this.fIsPositive) {
            ++this.fValueHigh;
            return true;
        }
        --this.fValueHigh;
        if (this.fValueHigh == -1L) {
            this.fIsPositive = true;
            this.fValueHigh = 0L;
            return false;
        }
        return true;
    }

    private boolean decrementHigh() {
        if (this.fIsPositive) {
            --this.fValueHigh;
            if (this.fValueHigh == -1L) {
                this.fIsPositive = false;
                this.fValueHigh = 0L;
                return false;
            }
            return true;
        }
        ++this.fValueHigh;
        return true;
    }

    public static void main(String[] args) {
        int runningLength = 100000;
        int startrange = 0;
        try {
            startrange = new Long(args[0]).intValue();
        }
        catch (Exception e) {
            startrange = 0;
        }
        int range = startrange;
        System.out.println("Safety checks disabled");
        RunningLongAverage special = new RunningLongAverage();
        special.combineValue(Long.MIN_VALUE);
        special.combineValue(Long.MIN_VALUE);
        special.combineValue(Long.MAX_VALUE);
        special.combineValue(Long.MAX_VALUE);
        special.combineValue(3L);
        special.combineValue(-5L);
        special.combineValue(8L);
        RunningLongAverage special2 = new RunningLongAverage();
        special2.combineValue(2L, 4L, 2L, 2L);
        Assertion.wilyAssert(special2.getCount() == 4L);
        Assertion.wilyAssert(special2.getAverage() == 2L);
        System.out.println("Special checks passed, starting regular testing....");
        System.out.println("Testing (range=" + (range == 0 ? "full" : "" + range) + ")");
        Random ran = new Random();
        RunningLongAverage rla = new RunningLongAverage();
        while (true) {
            rla.reset();
            long start = System.currentTimeMillis();
            for (int i = 0; i < 100000; ++i) {
                long nextVal = ran.nextLong();
                if (range != 0) {
                    nextVal %= (long)range;
                }
                rla.combineValue(nextVal);
            }
            System.out.println("  avg = " + rla.getAverage());
            long end = System.currentTimeMillis();
            System.out.println("This batch of 100000 took " + (end - start) + " ms");
        }
    }
}

