/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util;

import com.wily.util.ObserverAction;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class ObserverTracker {
    private IModuleFeedbackChannel fFeedback;
    private Object[] fObservers;

    public ObserverTracker(IModuleFeedbackChannel feedback) {
        this.fFeedback = feedback;
        this.fObservers = new Object[0];
    }

    public synchronized void addObserver(Object newObserver) {
        int oldLength = this.fObservers.length;
        Object[] newList = new Object[oldLength + 1];
        System.arraycopy(this.fObservers, 0, newList, 0, oldLength);
        newList[oldLength] = newObserver;
        this.fObservers = newList;
    }

    public synchronized void forEachObserverDo(ObserverAction action, Object parameter) {
        for (int x = 0; x < this.fObservers.length; ++x) {
            try {
                action.doAction(this.fObservers[x], parameter);
                continue;
            }
            catch (Exception e) {
                IModuleFeedbackChannel feedbackChannel = this.getModuleFeedback();
                if (feedbackChannel.isVerboseEnabled()) {
                    feedbackChannel.error("ObserverAction.doAction threw: " + action.toString() + " " + this.fObservers[x].toString());
                }
                feedbackChannel.verbose(e);
            }
        }
    }

    private IModuleFeedbackChannel getModuleFeedback() {
        return this.fFeedback;
    }
}

