/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.dnd;

import com.wily.ui.IGenericServices;
import com.wily.ui.datatransfer.KDataTransferConstants;
import com.wily.ui.dnd.ExtendedDropTarget;
import com.wily.ui.dnd.IExtendedDropTargetConspirator;
import com.wily.wilyassert.Assertion;
import com.wily.wilyassert.SwingAssertion;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.dnd.DragSource;
import javax.swing.JComponent;

public class DnDUtils
implements KDataTransferConstants {
    DnDUtils() {
    }

    public static void propagateDefaultDropTargetSync(IGenericServices genericServices, Component topComponent) {
        SwingAssertion.assertSwingSafe(topComponent);
        if (Boolean.getBoolean("java.awt.headless")) {
            return;
        }
        if (topComponent.getDropTarget() == null) {
            new ExtendedDropTarget(genericServices, topComponent);
        }
        if (topComponent instanceof Container) {
            Container parentContainer = (Container)topComponent;
            int childCount = parentContainer.getComponentCount();
            Component[] children = parentContainer.getComponents();
            for (int i = 0; i < childCount; ++i) {
                DnDUtils.propagateDefaultDropTargetSync(genericServices, children[i]);
            }
        }
    }

    public static Cursor dragActionToCursor(int action) {
        Cursor dragCursor = null;
        switch (action) {
            case 0x40000000: {
                dragCursor = DragSource.DefaultLinkDrop;
                break;
            }
            case 1: {
                dragCursor = DragSource.DefaultCopyDrop;
                break;
            }
            case 2: {
                dragCursor = DragSource.DefaultMoveDrop;
                break;
            }
            case 3: {
                dragCursor = DragSource.DefaultCopyDrop;
                break;
            }
            default: {
                Assertion.wilyAssert(false, "DataTransferUtils.dragActionToCursor unknown cursor for action: " + action);
            }
        }
        return dragCursor;
    }

    public static void initTopLevelDragAndDrop(IGenericServices genericServices, JComponent component, IExtendedDropTargetConspirator conspirator) {
        new ExtendedDropTarget(genericServices, component, conspirator);
        DnDUtils.propagateDefaultDropTargetSync(genericServices, component);
    }
}

