/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.filter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.filter.FirstNPerIntervalSampler;
import com.wily.introscope.agent.filter.ISampler;
import com.wily.introscope.agent.filter.ISamplerEx;
import com.wily.introscope.agent.filter.RandomSampler;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.text.IStringLocalizer;

final class SamplingManager
implements ISampler {
    private final ISampler[] fSamplers = new ISampler[]{new FirstNPerIntervalSampler(), new RandomSampler()};
    private boolean fEnabled;

    SamplingManager() {
    }

    @Override
    public synchronized void configure(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
        IStringLocalizer localizer = agent.IAgent_getStringLocalizer();
        configManager.add(new BooleanConfigurationProperty("introscope.agent.transactiontracer.sampling.enabled", Boolean.TRUE, null, true, false, feedback, kSamplingModule, localizer){

            @Override
            public void set(Object newValue) {
                SamplingManager.this.updateMasterEnabled((Boolean)newValue);
            }
        });
        ISampler[] iSamplerArray = this.fSamplers;
        int n = this.fSamplers.length;
        int n2 = 0;
        while (n2 < n) {
            ISampler sampler = iSamplerArray[n2];
            if (feedback.isTraceEnabled(kSamplingModule)) {
                feedback.trace(kSamplingModule, "Will configure " + sampler.getClass().getSimpleName());
            }
            sampler.configure(agent);
            ++n2;
        }
    }

    final synchronized void updateMasterEnabled(boolean value) {
        if (value == this.fEnabled) {
            return;
        }
        this.fEnabled = value;
        ISampler[] iSamplerArray = this.fSamplers;
        int n = this.fSamplers.length;
        int n2 = 0;
        while (n2 < n) {
            ISampler sampler = iSamplerArray[n2];
            if (sampler instanceof ISamplerEx) {
                ((ISamplerEx)sampler).masterEnable(value);
            }
            ++n2;
        }
    }

    @Override
    public boolean shouldSample() {
        if (!this.fEnabled) {
            return false;
        }
        ISampler[] iSamplerArray = this.fSamplers;
        int n = this.fSamplers.length;
        int n2 = 0;
        while (n2 < n) {
            ISampler sampler = iSamplerArray[n2];
            if (sampler.shouldSample()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

