/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.trace.IProbeInformationCreator;
import com.wily.introscope.agent.trace.ProbeInformation;

final class ProbeLookup {
    private static final int kDefaultInitialCapacity = 95;
    private static final float kLoadFactor = 0.75f;
    private final IProbeInformationCreator fCreator;
    private volatile Entry[] fTable;
    private int fCount;

    public ProbeLookup(IProbeInformationCreator creator) {
        this.fCreator = creator;
        this.fTable = new Entry[95];
        this.fCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Entry[] oldTable = null;
        ProbeLookup probeLookup = this;
        synchronized (probeLookup) {
            oldTable = this.fTable;
            this.fTable = new Entry[95];
            this.fCount = 0;
        }
        if (oldTable != null) {
            int i = 0;
            while (i < oldTable.length) {
                Entry e = oldTable[i];
                while (e != null) {
                    Entry c = e;
                    ProbeInformation cfr_ignored_0 = c.fValue;
                    e = c.fNext;
                    c.fNext = null;
                }
                oldTable[i] = null;
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProbeInformation getProbeInformation(int probeHashCode, String probeClassName, String probeMethodName, String probeMethodDescriptor, String runtimeFullClassName, Object sampleTracedObject, String tracerEncoding) {
        ProbeInformation info = this.get(probeHashCode = 37 * probeHashCode + runtimeFullClassName.hashCode(), probeClassName, probeMethodName, probeMethodDescriptor, runtimeFullClassName, tracerEncoding);
        if (info == null) {
            ProbeLookup probeLookup = this;
            synchronized (probeLookup) {
                info = this.get(probeHashCode, probeClassName, probeMethodName, probeMethodDescriptor, runtimeFullClassName, tracerEncoding);
                if (info == null) {
                    info = this.fCreator.IProbeInformationCreator_createProbeInformation(probeClassName, probeMethodName, probeMethodDescriptor, runtimeFullClassName, sampleTracedObject, tracerEncoding);
                    this.put(probeHashCode, probeClassName, probeMethodName, probeMethodDescriptor, runtimeFullClassName, tracerEncoding, info);
                }
            }
        }
        return info;
    }

    private void put(int probeHashCode, String probeClassName, String probeMethodName, String probeMethodDescriptor, String runtimeFullClassName, String tracerEncoding, ProbeInformation value) {
        Entry newEntry;
        int index = (probeHashCode & Integer.MAX_VALUE) % this.fTable.length;
        Entry e = this.fTable[index];
        this.fTable[index] = newEntry = new Entry(probeHashCode, probeClassName, probeMethodName, probeMethodDescriptor, runtimeFullClassName, tracerEncoding, value, e);
        ++this.fCount;
        if ((float)this.fCount > (float)this.fTable.length * 0.75f) {
            this.rehash();
        }
    }

    private ProbeInformation get(int probeHashCode, String probeClassName, String probeMethodName, String probeMethodDescriptor, String runtimeFullClassName, String tracerEncoding) {
        Entry[] currentTable = this.fTable;
        Entry e = currentTable[(probeHashCode & Integer.MAX_VALUE) % currentTable.length];
        while (e != null) {
            if (e.keyEquals(probeHashCode, probeClassName, probeMethodName, probeMethodDescriptor, runtimeFullClassName, tracerEncoding)) {
                return e.fValue;
            }
            e = e.fNext;
        }
        return null;
    }

    private void rehash() {
        Entry[] newTable = new Entry[this.fTable.length * 2 + 1];
        int i = 0;
        while (i < this.fTable.length) {
            Entry e = this.fTable[i];
            while (e != null) {
                Entry eCopy;
                int newIndex = (e.fProbeHashCode & Integer.MAX_VALUE) % newTable.length;
                Entry newNext = newTable[newIndex];
                newTable[newIndex] = eCopy = new Entry(e.fProbeHashCode, e.fProbeClassName, e.fProbeMethodName, e.fProbeMethodDescriptor, e.fRuntimeFullClassName, e.fTracerEncoding, e.fValue, newNext);
                e = e.fNext;
            }
            ++i;
        }
        this.fTable = newTable;
    }

    private static final class Entry {
        public final int fProbeHashCode;
        public final String fProbeClassName;
        public final String fProbeMethodName;
        public final String fProbeMethodDescriptor;
        public final String fRuntimeFullClassName;
        public final String fTracerEncoding;
        public final ProbeInformation fValue;
        public Entry fNext;

        private Entry(int probeHashCode, String probeClassName, String probeMethodName, String probeMethodDescriptor, String runtimeFullClassName, String tracerEncoding, ProbeInformation value, Entry next) {
            this.fProbeHashCode = probeHashCode;
            this.fProbeClassName = probeClassName;
            this.fProbeMethodName = probeMethodName;
            this.fProbeMethodDescriptor = probeMethodDescriptor;
            this.fRuntimeFullClassName = runtimeFullClassName;
            this.fTracerEncoding = tracerEncoding;
            this.fValue = value;
            this.fNext = next;
        }

        public boolean keyEquals(int probeHashCode, String probeClassName, String probeMethodName, String probeMethodDescriptor, String runtimeFullClassName, String tracerEncoding) {
            return this.fProbeHashCode == probeHashCode && this.fProbeClassName == probeClassName && this.fProbeMethodName == probeMethodName && this.fProbeMethodDescriptor == probeMethodDescriptor && this.fTracerEncoding == tracerEncoding && this.fRuntimeFullClassName.equals(runtimeFullClassName);
        }
    }
}

