/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.nio;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.dns.IDnsService;
import com.wily.introscope.agent.trace.nio.ChannelConfiguration;
import com.wily.util.adt.ConcurrentWeakThreadLocalHashMap;
import com.wily.util.adt.IConcurrentMapFactory15;
import com.wily.wilyassert.Assertion;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicReference;

public final class SocketChannelMap {
    private static AtomicReference<ConcurrentWeakThreadLocalHashMap<Object, ChannelInfo>> sChannelMapCache = new AtomicReference<Object>(null);

    private static final void initChannelMapCache() {
        try {
            IAgent agent = AgentShim.getAgent();
            IConcurrentMapFactory15 mapFactory = (IConcurrentMapFactory15)((Object)agent.IAgent_getConcurrentMapFactory());
            ConcurrentWeakThreadLocalHashMap map = mapFactory.getConcurrentWeakHashMap("ChannelMapCache");
            sChannelMapCache.set(map);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
    }

    public static final void put(SocketChannel channel, String resourceName, InetSocketAddress address, boolean isClientConnection) {
        if (channel != null && resourceName != null && address != null) {
            SocketChannelMap.put(channel, new ChannelInfo(resourceName, address, isClientConnection));
        }
    }

    public static final void put(ServerSocketChannel channel, String resourceName, InetSocketAddress address, boolean isClientConnection) {
        if (channel != null && resourceName != null && address != null) {
            SocketChannelMap.put(channel, new ChannelInfo(resourceName, address, isClientConnection));
        }
    }

    private static final void put(Object channel, ChannelInfo ra) {
        ConcurrentWeakThreadLocalHashMap<Object, ChannelInfo> map = sChannelMapCache.get();
        if (map == null) {
            SocketChannelMap.initChannelMapCache();
            map = sChannelMapCache.get();
        }
        if (map != null) {
            map.putWeak(channel, ra);
        }
    }

    private static final ChannelInfo get(Object channel) {
        ConcurrentWeakThreadLocalHashMap<Object, ChannelInfo> map = sChannelMapCache.get();
        if (map == null) {
            SocketChannelMap.initChannelMapCache();
            map = sChannelMapCache.get();
        }
        if (map != null) {
            return map.getWeak(channel);
        }
        return null;
    }

    public static final InetSocketAddress getAddress(Object channel) {
        ChannelInfo cInfo = SocketChannelMap.get(channel);
        if (cInfo != null) {
            return cInfo.getAddress();
        }
        return null;
    }

    public static final int getPort(Object channel) {
        InetSocketAddress addr = SocketChannelMap.getAddress(channel);
        if (addr != null) {
            return addr.getPort();
        }
        return -1;
    }

    public static String getDnsHostName(InetAddress inIpAddress) {
        String dnsName;
        try {
            IAgent agent = AgentShim.getAgent();
            IDnsService dnsService = agent.IAgent_getDnsService();
            dnsName = dnsService.getDnsHostNameByIPAddr(inIpAddress);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            dnsName = inIpAddress.getHostAddress();
        }
        catch (Exception exception) {
            dnsName = inIpAddress.getHostAddress();
        }
        return dnsName;
    }

    public static final String getHost(Object channel) {
        InetSocketAddress addr = SocketChannelMap.getAddress(channel);
        if (addr != null) {
            return SocketChannelMap.getDnsHostName(addr.getAddress());
        }
        return "Unknown Host";
    }

    public static final String getResourceName(Object channel) {
        ChannelInfo cInfo = SocketChannelMap.get(channel);
        if (cInfo != null) {
            return cInfo.getResourceName();
        }
        return null;
    }

    public static final boolean isClientConnection(Object channel) {
        ChannelInfo cInfo = SocketChannelMap.get(channel);
        if (cInfo != null) {
            return cInfo.isClientConnection();
        }
        return false;
    }

    public static final boolean isRequired(Object channelObject, IAgent agent) {
        ChannelConfiguration cc = ChannelConfiguration.getChannelConfiguration(agent);
        ChannelInfo cInfo = SocketChannelMap.get(channelObject);
        if (cInfo != null) {
            if (channelObject instanceof SocketChannel) {
                SocketChannel channel = (SocketChannel)channelObject;
                if (cInfo.isClientConnection()) {
                    SocketAddress ra = channel.socket().getRemoteSocketAddress();
                    if (ra != null && ra instanceof InetSocketAddress) {
                        InetSocketAddress remoteAddress = (InetSocketAddress)ra;
                        return cc.isRequired(1, remoteAddress.getAddress()) && cc.isRequired(4, remoteAddress.getPort());
                    }
                    Assertion.wilyAssert("Instrumentation error: socket not connected or remote address is not an InetSocketAddress");
                    return false;
                }
                SocketAddress ra = channel.socket().getLocalSocketAddress();
                if (ra != null && ra instanceof InetSocketAddress) {
                    return cc.isRequired(5, channel.socket().getLocalPort());
                }
                Assertion.wilyAssert("Instrumentation error: socket not connected or Local address is not an InetSocketAddress");
                return false;
            }
            ServerSocketChannel ssc = (ServerSocketChannel)channelObject;
            SocketAddress ra = ssc.socket().getLocalSocketAddress();
            if (ra != null && ra instanceof InetSocketAddress) {
                return cc.isRequired(5, ssc.socket().getLocalPort());
            }
            Assertion.wilyAssert("Instrumentation error: socket not connected or Local address is not an InetSocketAddress");
            return false;
        }
        return false;
    }

    private static final class ChannelInfo {
        private final String resourceName;
        private final InetSocketAddress address;
        private final boolean isClientConnection;

        private ChannelInfo(String resourceName, InetSocketAddress address, boolean isClientConnection) {
            this.resourceName = resourceName;
            this.address = address;
            this.isClientConnection = isClientConnection;
        }

        private final String getResourceName() {
            return this.resourceName;
        }

        private final InetSocketAddress getAddress() {
            return this.address;
        }

        private final boolean isClientConnection() {
            return this.isClientConnection;
        }
    }
}

