/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.util;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.util.ReflectionLookupException;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;

public class ReflectionLookupStore {
    private static final String[] EMPTY_STRING = new String[0];
    private static Map<String, WeakReference<Method>> methodReflectionCache;
    private static Map<String, WeakReference<Class>> classReflectionCache;
    private static Map<String, WeakReference<Field>> fieldReflectionCache;

    private static Map<String, WeakReference<Method>> getMethodReflectionCache() {
        if (methodReflectionCache == null) {
            try {
                methodReflectionCache = AgentShim.getAgent().IAgent_getConcurrentMapFactory().getConcurrentCappedMap("GenericMethodCache");
            }
            catch (AgentNotAvailableException agentNotAvailableException) {
                return null;
            }
        }
        return methodReflectionCache;
    }

    private static Map<String, WeakReference<Class>> getClassReflectionCache() {
        if (classReflectionCache == null) {
            try {
                classReflectionCache = AgentShim.getAgent().IAgent_getConcurrentMapFactory().getConcurrentCappedMap("GenericClassCache");
            }
            catch (AgentNotAvailableException agentNotAvailableException) {
                return null;
            }
        }
        return classReflectionCache;
    }

    private static Map<String, WeakReference<Field>> getFieldReflectionCache() {
        if (fieldReflectionCache == null) {
            try {
                fieldReflectionCache = AgentShim.getAgent().IAgent_getConcurrentMapFactory().getConcurrentCappedMap("GenericFieldCache");
            }
            catch (AgentNotAvailableException agentNotAvailableException) {
                return null;
            }
        }
        return fieldReflectionCache;
    }

    public static Method lookupMethod(Object instance, String name, boolean publicModifier, IModuleFeedbackChannel feedback) throws ReflectionLookupException {
        return ReflectionLookupStore.lookupMethod(instance, name, EMPTY_STRING, publicModifier, feedback);
    }

    public static Method lookupMethod(Object instance, String name, String[] strings, boolean publicModifier, IModuleFeedbackChannel feedback) throws ReflectionLookupException {
        return ReflectionLookupStore.lookupMethodOnClass(instance.getClass(), name, strings, publicModifier, feedback);
    }

    /*
     * Unable to fully structure code
     */
    public static Method lookupMethodOnClass(Class className, String methodName, String[] strings, boolean publicModifier, IModuleFeedbackChannel feedback) throws ReflectionLookupException {
        block11: {
            arguments = null;
            try {
                key = ReflectionLookupStore.getCacheKey(className.getClassLoader(), className.getName(), methodName);
                weakRefMethod = ReflectionLookupStore.getMethodReflectionCache().get(key);
                v0 = method = weakRefMethod == null ? null : (Method)weakRefMethod.get();
                if (method == null) {
                    arguments = ReflectionLookupStore.resolveParameterStrings(strings, className.getClassLoader());
                    if (publicModifier) {
                        method = className.getMethod(methodName, arguments);
                        argumentsBuffer = new StringBuilder();
                        if (arguments != null) {
                            var13_16 = arguments;
                            var12_19 = arguments.length;
                            var11_22 = 0;
                            while (var11_22 < var12_19) {
                                class1 = var13_16[var11_22];
                                argumentsBuffer.append(class1.getName());
                                argumentsBuffer.append(";");
                                ++var11_22;
                            }
                        }
                    } else {
                        method = className.getDeclaredMethod(methodName, arguments);
                        argumentsBuffer = new StringBuilder();
                        if (arguments != null) {
                            var13_17 = arguments;
                            var12_20 = arguments.length;
                            var11_23 = 0;
                            while (var11_23 < var12_20) {
                                class1 = var13_17[var11_23];
                                argumentsBuffer.append(class1.getName());
                                argumentsBuffer.append(";");
                                ++var11_23;
                            }
                        }
                    }
                    method.setAccessible(true);
                    ReflectionLookupStore.getMethodReflectionCache().put(key, new WeakReference<Method>(method));
                }
                return method;
            }
            catch (Exception e) {
                argumentsBuffer = new StringBuilder();
                if (arguments == null) break block11;
                var11_24 = arguments;
                class1 = arguments.length;
                argumentsBuffer = 0;
                ** while (argumentsBuffer < class1)
            }
lbl-1000:
            // 1 sources

            {
                class1 = var11_24[argumentsBuffer];
                argumentsBuffer.append(class1.getName());
                argumentsBuffer.append(";");
                ++argumentsBuffer;
                continue;
            }
        }
        methodsBuffer = new StringBuilder();
        var13_18 = methods = className.getMethods();
        var12_21 = methods.length;
        var11_25 = 0;
        while (var11_25 < var12_21) {
            method = var13_18[var11_25];
            methodsBuffer.append(method.toString());
            methodsBuffer.append(";");
            ++var11_25;
        }
        feedback.debug("Available methods on class " + className.getName() + ": " + methodsBuffer.toString());
        throw new ReflectionLookupException("Error looking up method " + methodName + " on " + className + " with parameters " + argumentsBuffer.toString(), e);
    }

    /*
     * Unable to fully structure code
     */
    public static Method lookupMethodOnClass(Class className, String methodName, Class[] arguments, boolean publicModifier, IModuleFeedbackChannel feedback, boolean useCaching) throws ReflectionLookupException {
        block5: {
            try {
                key = ReflectionLookupStore.getCacheKey(className.getClassLoader(), className.getName(), methodName);
                weakRefMethod = ReflectionLookupStore.getMethodReflectionCache().get(key);
                v0 = method = weakRefMethod == null ? null : (Method)weakRefMethod.get();
                if (method == null) {
                    method = publicModifier != false ? className.getMethod(methodName, arguments) : className.getDeclaredMethod(methodName, arguments);
                    method.setAccessible(true);
                    ReflectionLookupStore.getMethodReflectionCache().put(key, new WeakReference<Method>(method));
                }
                return method;
            }
            catch (Exception e) {
                argumentsBuffer = new StringBuffer();
                if (arguments == null) break block5;
                var11_12 = arguments;
                var10_14 = arguments.length;
                var9_16 = 0;
                ** while (var9_16 < var10_14)
            }
lbl-1000:
            // 1 sources

            {
                class1 = var11_12[var9_16];
                argumentsBuffer.append(class1.getName());
                argumentsBuffer.append(";");
                ++var9_16;
                continue;
            }
        }
        methodsBuffer = new StringBuffer();
        var13_18 = methods = className.getMethods();
        var12_19 = methods.length;
        var11_13 = 0;
        while (var11_13 < var12_19) {
            method = var13_18[var11_13];
            methodsBuffer.append(method.toString());
            methodsBuffer.append(";");
            ++var11_13;
        }
        feedback.error("Available methods on class " + className.getName() + ": " + methodsBuffer.toString());
        throw new ReflectionLookupException("Error looking up method " + methodName + " on " + className + " with parameters " + argumentsBuffer.toString(), e);
    }

    public static Method lookupMethod(Object instance, String methodName, Class[] parameterTypes, boolean publicModifier, IModuleFeedbackChannel feedback, boolean useCaching) throws ReflectionLookupException {
        return ReflectionLookupStore.lookupMethodOnClass(instance.getClass(), methodName, parameterTypes, publicModifier, feedback, useCaching);
    }

    public static Class[] resolveParameterStrings(String[] strings, ClassLoader classloader) throws ReflectionLookupException {
        Class[] classNames = new Class[strings.length];
        int i = 0;
        while (i < strings.length) {
            String className = strings[i];
            classNames[i] = ReflectionLookupStore.lookupClass(className, classloader);
            ++i;
        }
        return classNames;
    }

    public static Class lookupClass(String className, ClassLoader classloader) throws ReflectionLookupException {
        try {
            Class<?> lookupClass;
            String key = ReflectionLookupStore.getCacheKey(classloader, className);
            WeakReference<Class> weakRefClass = ReflectionLookupStore.getClassReflectionCache().get(key);
            Class<?> clazz = lookupClass = weakRefClass == null ? null : (Class<?>)weakRefClass.get();
            if (lookupClass == null) {
                lookupClass = Class.forName(className, false, classloader);
                ReflectionLookupStore.getClassReflectionCache().put(key, new WeakReference(lookupClass));
            }
            return lookupClass;
        }
        catch (Exception e) {
            throw new ReflectionLookupException("Error looking up class " + className, e);
        }
    }

    static String getCacheKey(ClassLoader classloader, String className) {
        return ReflectionLookupStore.getCacheKey(classloader, className, null);
    }

    static String getCacheKey(ClassLoader classloader, String className, String methodOrFieldName) {
        StringBuilder key = new StringBuilder();
        if (classloader != null) {
            key.append(classloader.getClass().getName()).append("#").append(Integer.toHexString(classloader.hashCode())).append("#");
        }
        key.append(className);
        if (methodOrFieldName != null && !methodOrFieldName.isEmpty()) {
            key.append("#").append(methodOrFieldName);
        }
        return key.toString();
    }

    public static Class<?> lookupClass(String className, ClassLoader classLoader, boolean initialize) throws ReflectionLookupException {
        try {
            Class<?> lookupClass;
            String key = ReflectionLookupStore.getCacheKey(classLoader, className);
            WeakReference<Class> weakRefClass = ReflectionLookupStore.getClassReflectionCache().get(key);
            Class<?> clazz = lookupClass = weakRefClass == null ? null : (Class<?>)weakRefClass.get();
            if (lookupClass == null) {
                lookupClass = Class.forName(className, initialize, classLoader);
                ReflectionLookupStore.getClassReflectionCache().put(key, new WeakReference(lookupClass));
            }
            return lookupClass;
        }
        catch (Exception e) {
            throw new ReflectionLookupException("Error looking up class " + className, e);
        }
    }

    public static Field lookupField(ClassLoader classLoader, String className, String fieldName, boolean publicModifier) throws ReflectionLookupException {
        try {
            Class searchClass = ReflectionLookupStore.lookupClass(className, classLoader);
            Field searchField = ReflectionLookupStore.lookupField(searchClass, fieldName, publicModifier);
            return searchField;
        }
        catch (Exception e) {
            throw new ReflectionLookupException("Error looking up field " + fieldName + " on class " + className, e);
        }
    }

    static Field lookupField(Class classInstance, String fieldName, boolean publicModifier) throws ReflectionLookupException, NoSuchFieldException, SecurityException {
        Field lookupField;
        String key = ReflectionLookupStore.getCacheKey(classInstance.getClassLoader(), classInstance.getName(), fieldName);
        WeakReference<Field> weakRefField = ReflectionLookupStore.getFieldReflectionCache().get(key);
        Field field = lookupField = weakRefField == null ? null : (Field)weakRefField.get();
        if (lookupField == null) {
            lookupField = publicModifier ? classInstance.getField(fieldName) : classInstance.getDeclaredField(fieldName);
            lookupField.setAccessible(true);
            ReflectionLookupStore.getFieldReflectionCache().put(key, new WeakReference<Field>(lookupField));
        }
        return lookupField;
    }
}

