/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.threaddump.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class WilyThreadInfo
implements Externalizable {
    private static final long serialVersionUID = 0L;
    public static final String kBlockedState = "BLOCKED";
    public static final String kNewState = "NEW";
    public static final String kRunnableState = "RUNNABLE";
    public static final String kTerminatedState = "TERMINATED";
    public static final String kTimedWaitingState = "TIMED_WAITING";
    public static final String kWaitingState = "WAITING";
    private long fThreadID;
    private String fThreadName;
    private long fBlockedTime;
    private long fBlockedCount;
    private long fWaitedTime;
    private long fWaitedCount;
    private String fLockName;
    private String fLockOwnerName;
    private long fLockOwnerID;
    private boolean fInNative;
    private boolean fSuspended;
    private String fThreadState;
    private StackTraceElement[] fStackTrace;
    private int fStackLength;
    private boolean fIsDeadlocked;
    private String fCorrelationId;
    private String fTrxTraceId;
    private String fComponent;
    private long fTimestamp;
    private static final int MAX_FRAMES = 1000;
    private static boolean isCurrent = false;

    public void setCurrent(boolean isCurrent) {
        WilyThreadInfo.isCurrent = isCurrent;
    }

    public WilyThreadInfo() {
    }

    public WilyThreadInfo(long threadID, String threadName, long blockedTime, long blockedCount, long waitedTime, long waitedCount, String lockName, String lockOwnerName, long lockOwnerID, boolean inNative, boolean suspended, String threadState, StackTraceElement[] stackTrace, boolean isDeadlocked) {
        this.fThreadID = threadID;
        this.fThreadName = threadName;
        this.fBlockedTime = blockedTime;
        this.fBlockedCount = blockedCount;
        this.fWaitedTime = waitedTime;
        this.fWaitedCount = waitedCount;
        this.fLockName = lockName;
        this.fLockOwnerName = lockOwnerName;
        this.fLockOwnerID = lockOwnerID;
        this.fInNative = inNative;
        this.fSuspended = suspended;
        this.fStackTrace = stackTrace;
        this.fStackLength = this.fStackTrace.length;
        this.fIsDeadlocked = isDeadlocked;
        this.fThreadState = threadState;
    }

    public WilyThreadInfo(String state, StackTraceElement[] stack) {
        this.fThreadState = state;
        this.fStackTrace = stack;
        this.fStackLength = stack.length;
    }

    private String ensureNonNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public long getBlockedCount() {
        return this.fBlockedCount;
    }

    public long getBlockedTime() {
        return this.fBlockedTime;
    }

    public long getThreadID() {
        return this.fThreadID;
    }

    public boolean isInNative() {
        return this.fInNative;
    }

    public String getLockName() {
        return this.fLockName;
    }

    public String getLockOwnerName() {
        return this.fLockOwnerName;
    }

    public long getLockOwnerID() {
        return this.fLockOwnerID;
    }

    public StackTraceElement[] getStackTrace() {
        return this.fStackTrace;
    }

    public void setStackTrace(StackTraceElement[] stack) {
        this.fStackTrace = stack;
        this.fStackLength = this.fStackTrace.length;
    }

    public void enforceStackTraceLength(int maxStackLength) {
        if (this.fStackLength <= maxStackLength) {
            return;
        }
        int framesToRemove = this.fStackLength - maxStackLength + 1;
        int firstFrameToRemove = (this.fStackLength - framesToRemove) / 2;
        StackTraceElement[] newStack = new StackTraceElement[maxStackLength];
        int i = 0;
        while (i < firstFrameToRemove) {
            newStack[i] = this.fStackTrace[i];
            ++i;
        }
        newStack[firstFrameToRemove] = new StackTraceElement("Ommitted", "frames", "count", framesToRemove);
        i = firstFrameToRemove + 1;
        while (i < maxStackLength) {
            newStack[i] = this.fStackTrace[i + framesToRemove - 1];
            ++i;
        }
        this.fStackTrace = newStack;
    }

    public int getStackLen() {
        return this.fStackLength;
    }

    public boolean isSuspended() {
        return this.fSuspended;
    }

    public String getThreadName() {
        return this.fThreadName;
    }

    public String getThreadState() {
        return this.fThreadState;
    }

    public long getWaitedCount() {
        return this.fWaitedCount;
    }

    public long getWaitedTime() {
        return this.fWaitedTime;
    }

    public boolean isDeadlocked() {
        return this.fIsDeadlocked;
    }

    public StackTraceElement getTopOfStackBelowObjectWait() {
        int i = 0;
        while (i < this.fStackTrace.length) {
            StackTraceElement elem = this.fStackTrace[i];
            if (!elem.getClassName().equals("java.lang.Object") || !elem.getMethodName().equals("wait")) {
                return elem;
            }
            ++i;
        }
        if (this.fStackTrace.length > 0) {
            return this.fStackTrace[this.fStackTrace.length - 1];
        }
        return null;
    }

    public boolean isBlocked() {
        return this.fThreadState.equals(kBlockedState);
    }

    public boolean isRunning() {
        return this.fThreadState.equals(kRunnableState);
    }

    public boolean isWaiting() {
        return this.fThreadState.equals(kTimedWaitingState) || this.fThreadState.equals(kWaitingState);
    }

    public String getCorrelationId() {
        return this.fCorrelationId;
    }

    public void setCorrelationId(String correlationId) {
        this.fCorrelationId = correlationId;
    }

    public String getTrxTraceId() {
        return this.fTrxTraceId;
    }

    public void setTrxTraceId(String trxTraceId) {
        this.fTrxTraceId = trxTraceId;
    }

    public String getComponent() {
        return this.fComponent;
    }

    public void setComponent(String component) {
        this.fComponent = component;
    }

    public long getTimestamp() {
        return this.fTimestamp;
    }

    public void setTimestamp(long timestamp) {
        this.fTimestamp = timestamp;
    }

    public boolean isInSockets() {
        if (this.fStackTrace.length == 0) {
            return false;
        }
        String topOfStackClass = this.fStackTrace[0].getClassName();
        return topOfStackClass.equals("java.net.PlainSocketImpl") || topOfStackClass.equals("java.net.PlainDatagramSocketImpl") || topOfStackClass.equals("java.net.SocketInputStream") || topOfStackClass.equals("java.net.SocketOutputStream");
    }

    public boolean statesAreEqual(WilyThreadInfo thread) {
        if (this.fThreadID == thread.fThreadID && this.fStackTrace.length == thread.fStackTrace.length && this.eq(this.fThreadName, thread.fThreadName) && this.eq(this.fLockName, thread.fLockName) && this.eq(this.fLockOwnerName, thread.fLockOwnerName) && this.fInNative == thread.fInNative && this.fSuspended == thread.fSuspended && this.eq(this.fThreadState, thread.fThreadState) && this.fIsDeadlocked == thread.fIsDeadlocked) {
            int i = 0;
            while (i < this.fStackTrace.length) {
                if (!this.eq(this.fStackTrace[i], thread.fStackTrace[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private boolean eq(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fThreadID = in.readLong();
        this.fThreadName = (String)in.readObject();
        this.fBlockedTime = in.readLong();
        this.fBlockedCount = in.readLong();
        this.fWaitedTime = in.readLong();
        this.fWaitedCount = in.readLong();
        this.fLockName = (String)in.readObject();
        this.fLockOwnerName = (String)in.readObject();
        this.fLockOwnerID = in.readLong();
        this.fInNative = in.readBoolean();
        this.fSuspended = in.readBoolean();
        this.fStackTrace = (StackTraceElement[])in.readObject();
        this.fStackLength = in.readInt();
        this.fIsDeadlocked = in.readBoolean();
        this.fThreadState = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.fThreadID);
        out.writeObject(this.fThreadName);
        out.writeLong(this.fBlockedTime);
        out.writeLong(this.fBlockedCount);
        out.writeLong(this.fWaitedTime);
        out.writeLong(this.fWaitedCount);
        out.writeObject(this.fLockName);
        out.writeObject(this.fLockOwnerName);
        out.writeLong(this.fLockOwnerID);
        out.writeBoolean(this.fInNative);
        out.writeBoolean(this.fSuspended);
        out.writeObject(this.fStackTrace);
        out.writeInt(this.fStackLength);
        out.writeBoolean(this.fIsDeadlocked);
        out.writeObject(this.fThreadState);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\"" + this.getThreadName() + "\"" + " Id=" + this.getThreadID() + " " + this.getThreadState());
        if (this.getLockName() != null) {
            sb.append(" on ").append(this.getLockName());
        }
        if (this.getLockOwnerName() != null) {
            sb.append(" owned by \"").append(this.getLockOwnerName()).append("\" Id=").append(this.getLockOwnerID());
        }
        if (this.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (this.isInNative()) {
            sb.append(" (in native)");
        }
        if (isCurrent) {
            sb.append("*current thread*");
        }
        sb.append('\n');
        int i = 0;
        while (i < this.getStackLen() && i < 1000) {
            StackTraceElement ste = this.getStackTrace()[i];
            sb.append("\tat ").append(ste.toString());
            sb.append('\n');
            ++i;
        }
        if (i < this.getStackLen()) {
            sb.append("\t...");
            sb.append('\n');
        }
        sb.append('\n');
        return sb.toString();
    }
}

