/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.widget;

import com.wily.ui.AxisLabel;
import com.wily.ui.KWilyUserInterfaceConstants;
import com.wily.ui.ThresholdValue;
import com.wily.ui.widget.AContinuousValueDisplayWidget;
import com.wily.util.Scale;
import com.wily.wilyassert.SwingAssertion;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class EqualizerBarWidget
extends AContinuousValueDisplayWidget
implements KWilyUserInterfaceConstants {
    public static final int kDefaultBarWidth = 6;
    public static final int kDefaultBarOutlineWidth = 2;
    public static final int kDefaultBarSeparation = 2;
    public static final int kDefaultEdgeOffset = 1;
    public static final int kDefaultPeakMemory = 1;
    public static final double kDefaultThresholdIndicatorToBarVerticalRatio = 1.75;
    public static final double kDefaultThresholdOffsetVerticalRatio = 1.4;
    private static final Color kDefaultEmptyBarOutlineColor = new Color(187, 187, 187);
    private static final Color kDefaultWarningHighlightColor = new Color(255, 204, 102);
    private static final Color kDefaultDangerHighlightColor = new Color(255, 51, 0);
    private int fBarWidth;
    private int fBarOutlineWidth;
    private int fBarSeparation;
    private double fThresholdIndicatorToBarVerticalRatio;
    private double fThresholdVerticalOffsetRatio;
    private int fTopEdgeOffset;
    private int fBottomEdgeOffset;
    private int fLeftEdgeOffset;
    private int fRightEdgeOffset;
    private boolean fHorizontal;
    private int fPeakMemory;
    private double[] fRecentValues;
    private Color fBelowThresholdColor = kSharedUnderThresholdColor;
    private Color fWarningThresholdColor = kSharedWarningThresholdColor;
    private Color fDangerThresholdColor = kSharedDangerThresholdColor;
    private Color fEmptyBarOutlineColor = kDefaultEmptyBarOutlineColor;
    private Color fWarningHighlightColor = kDefaultWarningHighlightColor;
    private Color fDangerHighlightColor = kDefaultDangerHighlightColor;
    private Color fHoleValueThresholdIndicatorColor = kDefaultEmptyBarOutlineColor;
    private double fPartitionValueOne;
    private double fPartitionValueTwo;
    private static final int kPreferredWidth = 150;
    private static final int kPreferredHeight = 18;

    EqualizerBarWidget(double holeValue) {
        super(holeValue);
        this.initFields();
    }

    public EqualizerBarWidget(int holeValue, Scale scale) {
        super(holeValue, scale);
        this.initFields();
    }

    public EqualizerBarWidget(double holeValue, Scale scale, ThresholdValue threshold) {
        super(holeValue, scale, threshold);
        this.initFields();
    }

    private void initFields() {
        this.fBarWidth = 6;
        this.fBarOutlineWidth = 2;
        this.fBarSeparation = 2;
        this.fThresholdIndicatorToBarVerticalRatio = 1.75;
        this.fThresholdVerticalOffsetRatio = 1.4;
        this.fTopEdgeOffset = 1;
        this.fBottomEdgeOffset = 1;
        this.fLeftEdgeOffset = 1;
        this.fRightEdgeOffset = 1;
        this.fHorizontal = true;
        this.fPeakMemory = 1;
        this.fRecentValues = new double[this.fPeakMemory];
        if (this.fThreshold != null) {
            if (this.fThreshold.isGreaterThanComparison()) {
                this.fPartitionValueOne = this.fThreshold.getCautionValue();
                this.fPartitionValueTwo = this.fThreshold.getDangerValue();
            } else {
                this.fPartitionValueTwo = this.fThreshold.getCautionValue();
                this.fPartitionValueOne = this.fThreshold.getDangerValue();
                this.fDangerThresholdColor = this.fBelowThresholdColor = this.fDangerThresholdColor;
            }
        }
    }

    public void setCurrentValue(double value) {
        System.arraycopy(this.fRecentValues, 1, this.fRecentValues, 0, this.fPeakMemory - 1);
        this.fRecentValues[this.fPeakMemory - 1] = this.fCurrentValue;
        super.setCurrentValue(value);
    }

    public void setBarWidth(int barWidth) {
        this.fBarWidth = barWidth;
    }

    public void setBarSeparation(int barSeparation) {
        this.fBarSeparation = barSeparation;
    }

    public void setEdgeOffset(int top, int left, int bottom, int right) {
        this.fTopEdgeOffset = top;
        this.fBottomEdgeOffset = bottom;
        this.fLeftEdgeOffset = left;
        this.fRightEdgeOffset = right;
    }

    public void setHorizontal(boolean horizontal) {
        this.fHorizontal = horizontal;
    }

    public double getRecentPeakValue() {
        double peakValue = this.fScale.getMin();
        for (int i = 0; i < this.fRecentValues.length; ++i) {
            if (!(this.fRecentValues[i] > peakValue)) continue;
            peakValue = this.fRecentValues[i];
        }
        return peakValue;
    }

    public Dimension getPreferredSize() {
        return new Dimension(150, 18);
    }

    public void draw(Graphics g, Dimension d) {
        SwingAssertion.assertSwingSafe("must draw from swing thread");
        Graphics2D g2D = (Graphics2D)g;
        g2D.setStroke(new BasicStroke(this.fBarOutlineWidth));
        if (!this.fHorizontal) {
            d = new Dimension(d.height, d.width);
        }
        ThresholdValue thresholdValue = this.hasThreshold() ? (ThresholdValue)this.getThresholdValue().clone() : null;
        Scale scale = (Scale)this.getScale().clone();
        double currentValue = this.getCurrentValue();
        if (this.currentValueIsHoleValue()) {
            this.drawEmptyRanges(g2D, d);
        } else {
            AContinuousValueDisplayWidget.RangeStyles rangeStyles = this.getRangeStyles(thresholdValue, currentValue);
            this.drawRanges(g2D, d, rangeStyles, scale);
        }
        this.drawThresholdIndicatorsIfNecessary(g2D, d, thresholdValue, scale);
        if (!this.currentValueIsHoleValue()) {
            this.drawAxisLabels(g2D, d);
        }
    }

    private void drawAxisLabels(Graphics2D g2D, Dimension d) {
        AxisLabel axisLabel = new AxisLabel(this.fScale, this.fLeftEdgeOffset, this.fRightEdgeOffset, this.fTopEdgeOffset);
        axisLabel.setFont(kDefaultLabelFont);
        axisLabel.setColor(kDefaultLabelColor);
        if (this.fThreshold != null) {
            axisLabel.addInterestPoint(this.fThreshold.getDangerValue());
            if (this.fThreshold.hasCaution()) {
                axisLabel.addInterestPoint(this.fThreshold.getCautionValue());
            }
        }
        axisLabel.draw(g2D, d);
    }

    private void drawRanges(Graphics2D g2D, Dimension d, AContinuousValueDisplayWidget.RangeStyles rangeStyles, Scale scale) {
        int numBars = (d.width - this.fLeftEdgeOffset - this.fRightEdgeOffset - this.fBarWidth) / (this.fBarWidth + this.fBarSeparation) + 1;
        int oldBar = (int)((this.getRecentPeakValue() - this.fScale.getMin()) / this.fScale.getBreadth() * (double)numBars);
        for (int i = 1; i <= numBars; ++i) {
            double currentValue = (double)(i * (this.fBarWidth + this.fBarSeparation)) / (double)(d.width - this.fLeftEdgeOffset - this.fRightEdgeOffset) * (scale.getMax() - scale.getMin()) + scale.getMin();
            AContinuousValueDisplayWidget.Style barStyle = i == oldBar ? rangeStyles.getRawStyleForValue(currentValue) : rangeStyles.getMaskedStyleForValue(currentValue);
            this.paintBar(g2D, d, barStyle.getColor(), i, barStyle.isFilled());
        }
    }

    private void drawEmptyRanges(Graphics2D g2D, Dimension d) {
        int numBars = (d.width - this.fLeftEdgeOffset - this.fRightEdgeOffset - this.fBarWidth) / (this.fBarWidth + this.fBarSeparation) + 1;
        for (int i = 1; i <= numBars; ++i) {
            this.paintBar(g2D, d, null, i, false);
        }
    }

    private void drawThresholdIndicatorsIfNecessary(Graphics2D g2D, Dimension d, ThresholdValue thresholdValue, Scale scale) {
        boolean drawWarningIndicator = thresholdValue != null && thresholdValue.hasCaution() && thresholdValue.getCautionValue() < scale.getMax() && thresholdValue.getCautionValue() > scale.getMin();
        boolean drawDangerIndicator = thresholdValue != null && thresholdValue.getDangerValue() < scale.getMax() && thresholdValue.getDangerValue() > scale.getMin();
        int indicatorHeight = d.height - this.fTopEdgeOffset - this.fBottomEdgeOffset;
        if (drawWarningIndicator) {
            int warningIndicatorHorizontalOffset = (int)((thresholdValue.getCautionValue() - scale.getMin()) / (scale.getMax() - scale.getMin()) * (double)(d.width - this.fLeftEdgeOffset - this.fRightEdgeOffset));
            int warningIndicatorHorizontalAdjustment = warningIndicatorHorizontalOffset % (this.fBarWidth + this.fBarSeparation);
            warningIndicatorHorizontalOffset -= (warningIndicatorHorizontalAdjustment += this.fLeftEdgeOffset);
            if (this.currentValueIsHoleValue()) {
                g2D.setColor(this.fHoleValueThresholdIndicatorColor);
            } else {
                g2D.setColor(this.fWarningHighlightColor);
            }
            g2D.drawLine(warningIndicatorHorizontalOffset, this.fTopEdgeOffset, warningIndicatorHorizontalOffset + this.fBarOutlineWidth, this.fTopEdgeOffset);
            g2D.drawLine(warningIndicatorHorizontalOffset, this.fTopEdgeOffset, warningIndicatorHorizontalOffset, indicatorHeight);
            if (this.currentValueIsHoleValue()) {
                g2D.setColor(this.fHoleValueThresholdIndicatorColor);
            } else {
                g2D.setColor(this.fWarningThresholdColor);
            }
            g2D.drawLine(warningIndicatorHorizontalOffset + this.fBarOutlineWidth, this.fTopEdgeOffset, warningIndicatorHorizontalOffset + this.fBarOutlineWidth, indicatorHeight);
            g2D.drawLine(warningIndicatorHorizontalOffset, indicatorHeight, warningIndicatorHorizontalOffset + this.fBarOutlineWidth, indicatorHeight);
        }
        if (drawDangerIndicator) {
            int dangerIndicatorHorizontalOffset = (int)((thresholdValue.getDangerValue() - scale.getMin()) / (scale.getMax() - scale.getMin()) * (double)(d.width - this.fLeftEdgeOffset - this.fRightEdgeOffset));
            int dangerIndicatorHorizontalAdjustment = dangerIndicatorHorizontalOffset % (this.fBarWidth + this.fBarSeparation);
            dangerIndicatorHorizontalOffset -= (dangerIndicatorHorizontalAdjustment += this.fLeftEdgeOffset);
            if (this.currentValueIsHoleValue()) {
                g2D.setColor(this.fHoleValueThresholdIndicatorColor);
            } else {
                g2D.setColor(this.fDangerHighlightColor);
            }
            g2D.drawLine(dangerIndicatorHorizontalOffset, this.fTopEdgeOffset, dangerIndicatorHorizontalOffset + this.fBarOutlineWidth, this.fTopEdgeOffset);
            g2D.drawLine(dangerIndicatorHorizontalOffset, this.fTopEdgeOffset, dangerIndicatorHorizontalOffset, indicatorHeight);
            if (this.currentValueIsHoleValue()) {
                g2D.setColor(this.fHoleValueThresholdIndicatorColor);
            } else {
                g2D.setColor(this.fDangerThresholdColor);
            }
            g2D.drawLine(dangerIndicatorHorizontalOffset + this.fBarOutlineWidth, this.fTopEdgeOffset, dangerIndicatorHorizontalOffset + this.fBarOutlineWidth, indicatorHeight);
            g2D.drawLine(dangerIndicatorHorizontalOffset, indicatorHeight, dangerIndicatorHorizontalOffset + this.fBarOutlineWidth, indicatorHeight);
        }
    }

    private void paintBar(Graphics2D g2D, Dimension d, Color fillColor, int whichBar, boolean filled) {
        int barHorizontalOffset = this.fLeftEdgeOffset + (this.fBarWidth + this.fBarSeparation) * (whichBar - 1);
        int barHeight = (int)((double)(d.height - this.fTopEdgeOffset - this.fBottomEdgeOffset) / this.fThresholdIndicatorToBarVerticalRatio);
        int barVerticalOffset = (int)((double)(d.height - barHeight) / (1.0 + this.fThresholdVerticalOffsetRatio) * this.fThresholdVerticalOffsetRatio);
        this.drawRect(g2D, d, fillColor, barHorizontalOffset, barVerticalOffset, this.fBarWidth, barHeight, filled);
    }

    private void drawRect(Graphics2D g2D, Dimension d, Color fillColor, int x, int y, int width, int height, boolean filled) {
        if (this.fHorizontal) {
            if (filled) {
                g2D.setColor(fillColor);
                g2D.fillRect(x, y, width, height);
            } else {
                g2D.setColor(this.fEmptyBarOutlineColor);
                int fudgeFactor = this.fBarOutlineWidth - 1;
                g2D.drawRect(x + fudgeFactor, y + fudgeFactor, width - fudgeFactor - 1, height - fudgeFactor - 1);
            }
        } else if (filled) {
            g2D.setColor(fillColor);
            g2D.fillRect(y, d.width - x - width, height, width);
        } else {
            g2D.setColor(this.fEmptyBarOutlineColor);
            int fudgeFactor = this.fBarOutlineWidth - 1;
            g2D.drawRect(y + fudgeFactor, d.width - x - width + fudgeFactor, height - fudgeFactor - 1, width - fudgeFactor - 1);
        }
    }
}

