/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.exitpoint.stacktrace;

import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.correlation.CrossProcessCorrelationAdmin;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.feature.IThreadStackSnapshotHelper;
import com.wily.introscope.agent.intelligent.detection.ConditionalTraceRecorder;
import com.wily.introscope.agent.intelligent.detection.RecordingData;
import com.wily.introscope.agent.intelligent.detection.StackTraceProvider;
import com.wily.introscope.agent.intelligent.detection.cb.BaseCircuitBreaker;
import com.wily.introscope.agent.intelligent.detection.rules.CommonUtils;
import com.wily.introscope.agent.intelligent.exitpoint.ExitPointDetectionConfiguration;
import com.wily.introscope.agent.intelligent.exitpoint.stacktrace.ThreadSelector;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.intelligent.Logger;

public class ExitPointStackTraceRecorder
extends BaseCircuitBreaker
implements ConditionalTraceRecorder {
    private static final Logger.ILoggingHandler LOGGER = ExitPointDetectionConfiguration.getLogger();
    private final ThreadSelector threadSelector = new ThreadSelector();

    public ExitPointStackTraceRecorder() {
        super("Exit Point Detection Circuit Breaker", ExitPointDetectionConfiguration.getCircuitBreakerMaxWaitIntervals());
    }

    @Override
    public boolean record(RecordingData threadLocalRecData, StackTraceProvider provider) {
        if (this.shouldRecordStackTrace(threadLocalRecData)) {
            boolean status = this.recordTraceInternal(threadLocalRecData);
            if (status) {
                this.notifyRecordingListeners(threadLocalRecData);
            }
            return status;
        }
        return false;
    }

    private boolean recordTraceInternal(RecordingData threadLocalData) {
        LOGGER.logDebugMessage("StackTraceRecorder: Recording stack trace in repository");
        Thread t = Thread.currentThread();
        StackTraceElement[] traceElements = t.getStackTrace();
        boolean status = threadLocalData.acceptTrace(traceElements);
        IThreadStackSnapshotHelper helper = ErrorFeature.sThreadStackHelper;
        if (helper != null) {
            VirtualStack.TransactionCache cache = VirtualStack.getTransactionCache();
            IStackElement root = cache.getRoot();
            String component = cache.getFrontend();
            String txid = CrossProcessCorrelationAdmin.getTransactionIdFromCacheForSnapshot((IStackElement)root);
            String corid = CrossProcessCorrelationAdmin.getCorrelationIdFromCacheForSnapshot((IStackElement)root);
            if (txid != null) {
                helper.sendThreadStackSnapshot(component, "Exit Point Detection", null, null, traceElements, corid, txid, t);
            }
        }
        return status;
    }

    private void logTraceIfEnabled(StackTraceElement[] traceElements) {
        if (LOGGER.isTraceEnabled() && ExitPointDetectionConfiguration.shouldLogStackTraces()) {
            String traceAsString = CommonUtils.getStringRepresentationOfTrace((StackTraceElement[])traceElements);
            LOGGER.logTraceMessage("Stack Trace: \n" + traceAsString);
        }
    }

    private boolean shouldRecordStackTrace(RecordingData threadLocalData) {
        if (this.isCircuitOpen()) {
            return false;
        }
        VirtualStack.TransactionCache cache = VirtualStack.getTransactionCache();
        if (cache.getStartTransactionElement() != null && cache.getBackend() == null) {
            return this.threadSelector.shouldRecordTrace(threadLocalData);
        }
        return false;
    }

    private boolean isEntryPointInStack(VirtualStack.TransactionCache cache) {
        ITransactionElement txnElement = cache.getStartTransactionElement();
        return txnElement != null && txnElement instanceof IBlameTransactionElement && ((IBlameTransactionElement)txnElement).isAutomaticEntryPoint();
    }

    private void notifyRecordingListeners(RecordingData threadLocalData) {
        this.threadSelector.notifyOnRecording(threadLocalData);
    }

    public ThreadSelector getThreadSelector() {
        return this.threadSelector;
    }

    @Override
    protected boolean shouldRunCircuitBreaker() {
        return ExitPointDetectionConfiguration.isExitPointDetectionEnabled();
    }

    public void setRecordingStatus(boolean enabled) {
        this.setCircuitState(enabled ? BaseCircuitBreaker.CircuitState.CLOSED : BaseCircuitBreaker.CircuitState.OPEN);
    }

    void resetCircuitBreaker() {
        this.reset();
    }
}

