/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.finder;

import com.wily.util.finder.IIndexedPropertiesFinder;
import com.wily.util.finder.IIndexedPropertiesFinderFeedback;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.io.FileInputStream;

public class SystemEnvironmentProfileFinder
implements IIndexedPropertiesFinder {
    private final IStringLocalizer fLocalizer;
    private final String fProfilePathKey;

    public SystemEnvironmentProfileFinder(IStringLocalizer local, String profilePathKey) {
        Assertion.wilyAssert(local != null);
        Assertion.wilyAssert(profilePathKey != null);
        this.fLocalizer = local;
        this.fProfilePathKey = profilePathKey;
    }

    public IndexedProperties IIndexedPropertiesFinder_findProperties(IIndexedPropertiesFinderFeedback feedback) {
        IndexedProperties resultProps = null;
        String statusMessage = "";
        String profilePath = null;
        try {
            statusMessage = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Profile_Search_System_Property_Attempt_Message", this.fProfilePathKey);
            feedback.IIndexedPropertiesFinderFeedback_feedbackStatus(statusMessage);
            profilePath = System.getProperty(this.fProfilePathKey);
            if (profilePath != null) {
                statusMessage = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Profile_Search_System_Property_Attempt_With_Value_Message", profilePath);
                feedback.IIndexedPropertiesFinderFeedback_feedbackStatus(statusMessage);
                resultProps = new IndexedProperties();
                resultProps.load(new FileInputStream(profilePath));
                statusMessage = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Profile_Search_System_Property_Succeeded_Message", profilePath);
                feedback.IIndexedPropertiesFinderFeedback_feedbackSuccess(statusMessage);
            } else {
                statusMessage = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Profile_Search_System_Property_Not_Found_Message", this.fProfilePathKey);
                feedback.IIndexedPropertiesFinderFeedback_feedbackFailure(statusMessage);
            }
        }
        catch (Throwable t) {
            statusMessage = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Profile_Search_System_Property_Failed_Message", profilePath, t.getClass().getName(), t.getMessage());
            feedback.IIndexedPropertiesFinderFeedback_feedbackFailure(statusMessage);
            resultProps = null;
        }
        return resultProps;
    }
}

