/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.metric.calculator;

import com.wily.introscope.agent.metric.calculator.CalculatorService;
import com.wily.introscope.agent.metric.calculator.MetricPatternUtils;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.IncompatibleTypesException;
import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.gatherer.IGatherer;

public abstract class Operation {
    protected String resultMetricPattern;
    protected Object[] resultTokens;
    protected CalculatorService service;

    public Operation setResultMetric(String metric) {
        this.resultMetricPattern = metric;
        this.resultTokens = MetricPatternUtils.parseMetricPattern(this.resultMetricPattern);
        return this;
    }

    public Operation setService(CalculatorService service) {
        this.service = service;
        return this;
    }

    public abstract IMetricDataValue invoke(String[] var1);

    protected void recordResult(String[] vars, IMetricDataValue value) {
        if (this.resultTokens == null || this.service == null) {
            return;
        }
        String metric = MetricPatternUtils.resolveMetric(this.resultTokens, vars);
        CalculatorService.OutputMetric out = this.service.getOutputMetric(metric);
        if (out == null) {
            out = new CalculatorService.OutputMetric(value);
            this.service.putOutputMetric(metric, out);
        } else {
            IGatherer gatherer = out.getGatherer();
            try {
                gatherer.acceptValueNonSync(value);
            }
            catch (IncompatibleTypesException e) {
                this.service.getFeedback().debug(this.service.getModule(), "Metric aggregation error: ", (Throwable)e);
            }
        }
        AgentMetric m = null;
        try {
            m = AgentMetric.getAgentMetric((String)metric, (int)value.getType());
        }
        catch (BadlyFormedNameException e) {
            this.service.getFeedback().debug(this.service.getModule(), "Metric creation error: ", (Throwable)e);
        }
        this.service.updateLastSeenMetricCache(m);
    }
}

