/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing.filechooser;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;

public class CompoundFileFilter
extends FileFilter {
    public static final int kIntersection = 1;
    public static final int kUnion = 2;
    private Vector fFilters;
    private int fFilterType;
    private String fDescription;

    public CompoundFileFilter(String localizedDescription) {
        this(localizedDescription, 2);
    }

    public CompoundFileFilter(String localizedDescription, int filterType) {
        if (filterType != 1 && filterType != 2) {
            throw new IllegalArgumentException("Invalid compound filter type");
        }
        this.fDescription = localizedDescription;
        this.fFilterType = filterType;
        this.fFilters = new Vector();
    }

    public void addFileFilter(FileFilter filter) {
        this.fFilters.addElement(filter);
    }

    public boolean accept(File f) {
        Enumeration enumeration = this.fFilters.elements();
        while (enumeration.hasMoreElements()) {
            FileFilter filter = (FileFilter)enumeration.nextElement();
            switch (this.fFilterType) {
                case 2: {
                    if (!filter.accept(f)) break;
                    return true;
                }
                case 1: {
                    if (filter.accept(f)) break;
                    return false;
                }
            }
        }
        return this.fFilterType == 1;
    }

    public String getDescription() {
        return this.fDescription;
    }
}

