/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util;

import com.wily.util.CollectionUtilities;
import com.wily.util.event.EventMarkedQueue;
import com.wily.util.event.EventMarker;
import com.wily.util.event.InvalidEventMarkerException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class JournaledList {
    private final EventMarkedQueue fListCopiesQueue;
    private LinkedList fCurrentList;

    public JournaledList(EventMarker creationEventMarker, long agingWindowInMilliseconds) {
        this.fListCopiesQueue = new EventMarkedQueue(agingWindowInMilliseconds);
        this.journalAndSetCurrentList(creationEventMarker, new LinkedList());
    }

    public void add(EventMarker eventMarker, int index, Object element) {
        LinkedList newList = this.getShallowCopyOfCurrentList();
        newList.add(index, element);
        this.journalAndSetCurrentList(eventMarker, newList);
    }

    public void remove(EventMarker eventMarker, int index) {
        LinkedList newList = this.getShallowCopyOfCurrentList();
        newList.remove(index);
        this.journalAndSetCurrentList(eventMarker, newList);
    }

    public void clear(EventMarker eventMarker) {
        LinkedList newList = this.getShallowCopyOfCurrentList();
        newList.clear();
        this.journalAndSetCurrentList(eventMarker, newList);
    }

    public void setContents(EventMarker eventMarker, Collection collection) {
        LinkedList newList = new LinkedList(collection);
        this.journalAndSetCurrentList(eventMarker, newList);
    }

    public Object get(int index) {
        return this.getCurrentList().get(index);
    }

    public Object get(EventMarker eventMarker, int index) throws InvalidEventMarkerException {
        return this.getListForEventMarker(eventMarker).get(index);
    }

    public int indexOf(Object object) {
        return this.getCurrentList().indexOf(object);
    }

    public int indexOf(EventMarker eventMarker, Object object) throws InvalidEventMarkerException {
        return this.getListForEventMarker(eventMarker).indexOf(object);
    }

    public int size() {
        return this.getCurrentList().size();
    }

    public int size(EventMarker eventMarker) throws InvalidEventMarkerException {
        return this.getListForEventMarker(eventMarker).size();
    }

    public Iterator iterator(EventMarker eventMarker) throws InvalidEventMarkerException {
        return this.getListForEventMarker(eventMarker).iterator();
    }

    private LinkedList getCurrentList() {
        return this.fCurrentList;
    }

    private LinkedList getShallowCopyOfCurrentList() {
        return (LinkedList)this.getCurrentList().clone();
    }

    private void journalAndSetCurrentList(EventMarker eventMarker, LinkedList list) {
        this.fCurrentList = list;
        this.fListCopiesQueue.add(eventMarker, list);
    }

    private List getListForEventMarker(EventMarker eventMarker) throws InvalidEventMarkerException {
        return (List)this.fListCopiesQueue.get(eventMarker);
    }

    public void debug_dumpList(EventMarker eventMarker, PrintStream ps) throws InvalidEventMarkerException {
        CollectionUtilities.dumpList(this.getListForEventMarker(eventMarker), ps);
    }

    public void debug_dumpList(PrintStream ps) throws InvalidEventMarkerException {
        CollectionUtilities.dumpList((List)this.getCurrentList(), ps);
    }

    public void debug_dumpList(PrintWriter pw) throws InvalidEventMarkerException {
        CollectionUtilities.dumpList((List)this.getCurrentList(), pw);
    }
}

