/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.autoprobe.inherit;

import com.wily.diagnos.cmp.classmatcher.DGCompoundClassMatcher;
import com.wily.diagnos.cmp.classmatcher.DGExactClassMatcher;
import com.wily.diagnos.cmp.classmatcher.IClassMatcher;
import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.directives.builder.TracerGroupBuilder;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.tracer.builder.MethodTracerBuilder;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.introscope.autoprobe.IAutoProbeConfig;
import com.wily.introscope.autoprobe.ICompilerLogger;
import com.wily.introscope.autoprobe.inherit.ClassMatcherRepository;
import com.wily.introscope.autoprobe.inherit.ClassMatcherTracerGroupMapping;
import com.wily.introscope.autoprobe.inherit.ClassRepository;
import com.wily.introscope.autoprobe.inherit.RuntimeModeledClass;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.java.ClassName;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.feedback.SimpleModuleFeedbackChannel;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.validate.ValidationException;
import java.lang.instrument.Instrumentation;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MultipleInheritanceHandler {
    private static final String kDynamicInstrumentBehaviorName = "Introscope Multiple Inheritance Behavior";
    private long kBehaviorInterval = 300000L;
    public static final String kMultipleInheritancePollingInterval = "introscope.autoprobe.hierarchysupport.pollIntervalMinutes";
    public static final String kMultipleInheritanceEnabled = "introscope.autoprobe.hierarchysupport.enabled";
    public static final String kDisableLogging = "introscope.autoprobe.hierarchysupport.disableLogging";
    public static final String kDisableDirectivesChange = "introscope.autoprobe.hierarchysupport.disableDirectivesChange";
    public static final String kBehaviorRunOnceOnly = "introscope.autoprobe.hierarchysupport.runOnceOnly";
    public static final String kExecutionCount = "introscope.autoprobe.hierarchysupport.executionCount";
    public static final String kCustomModuleName = "inheritance";
    private static final String kWhiteSpace = " ";
    private IModuleFeedbackChannel customChannel;
    private static Module fModule = new Module("MultipleInheritanceHandler");
    private final IAgent fAgent;
    private final IAutoProbeConfig fAutoProbe;
    private final Instrumentation fInstrumentation;
    private final IModuleFeedbackChannel fFeedback;
    private final ICompilerLog fLog;
    private final IStringLocalizer fLocalizer;
    private final IntervalHeartbeat fHeartbeat;
    private boolean fDisableLogging;
    private boolean fDisableDirectivesChange;
    private boolean fRunOnceOnly;
    private int fExecutionCount;
    private boolean kLoggedDirectiveChangeMessage;
    private ConfigurationManager fConfigurationManager;
    private volatile IRegisteredBehavior fDirectivesBehavior;

    public MultipleInheritanceHandler(IAgent agent, IDynamicInstrumentationTransformer transformer, ICompilerLogger logger, IAutoProbeConfig configRepository, Instrumentation instrumentation) {
        this.fAgent = agent;
        this.fAutoProbe = configRepository;
        this.fInstrumentation = instrumentation;
        this.fFeedback = this.fAgent.IAgent_getModuleFeedback();
        this.fLog = logger.getCompilerLog();
        this.fLocalizer = this.fAgent.IAgent_getStringLocalizer();
        this.fHeartbeat = this.fAgent.IAgent_getConfigHeartbeat();
        this.fConfigurationManager = this.fAgent.IAgent_getConfigurationManager();
        this.customChannel = new SimpleModuleFeedbackChannel(this.fFeedback, kCustomModuleName);
        this.doInitialization();
    }

    private void toggleMultipleInheritanceSupport(boolean status) {
        if (status) {
            this.registerHeartBeat();
        } else {
            if (this.fDirectivesBehavior != null) {
                this.fDirectivesBehavior.close();
            }
            this.fFeedback.info(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Multiple_Inheritance_Disabled", ""));
        }
    }

    private void doInitialization() {
        this.fDisableLogging = this.fAgent.IAgent_getIndexedProperties().getBooleanProperty(kDisableLogging, false);
        this.fDisableDirectivesChange = this.fAgent.IAgent_getIndexedProperties().getBooleanProperty(kDisableDirectivesChange, false);
        this.fRunOnceOnly = this.fAgent.IAgent_getIndexedProperties().getBooleanProperty(kBehaviorRunOnceOnly, true);
        long pollingInterval = this.fAgent.IAgent_getIndexedProperties().getLongProperty(kMultipleInheritancePollingInterval);
        if (pollingInterval > 0L) {
            this.kBehaviorInterval = pollingInterval * 60L * 1000L;
        }
        this.fFeedback.debug("Polling interval set to " + this.kBehaviorInterval / 60000L + " minute/s");
        BooleanConfigurationProperty autoToggleEnable = new BooleanConfigurationProperty(kMultipleInheritanceEnabled, Boolean.FALSE, "Enables/Disables Multiple Inheritance Setting", true, false, this.fFeedback, fModule, this.fLocalizer){

            public void set(Object newValue) {
                boolean status = (Boolean)newValue;
                MultipleInheritanceHandler.this.toggleMultipleInheritanceSupport(status);
            }
        };
        this.fConfigurationManager.add((ConfigurationProperty)autoToggleEnable, true);
    }

    private void registerHeartBeat() {
        if (!this.fInstrumentation.isRedefineClassesSupported()) {
            this.fFeedback.warn(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Multiple_Inheritance_Disabled", ""));
        } else {
            String msg = "";
            MultipleInheritanceBehavior directivesBehavior = new MultipleInheritanceBehavior();
            this.fExecutionCount = this.fAgent.IAgent_getIndexedProperties().getIntProperty(kExecutionCount);
            if (this.fRunOnceOnly && this.fExecutionCount == 0) {
                this.fDirectivesBehavior = this.fHeartbeat.addBehavior((ITimestampedRunnable)directivesBehavior, kDynamicInstrumentBehaviorName, true, this.kBehaviorInterval, false, 1);
                msg = "Will run only once after [" + this.kBehaviorInterval / 60000L + "] minutes";
            } else if (this.fExecutionCount == 0) {
                this.fDirectivesBehavior = this.fHeartbeat.addBehavior((ITimestampedRunnable)directivesBehavior, kDynamicInstrumentBehaviorName, true, this.kBehaviorInterval, false);
                msg = "Will run after every [" + this.kBehaviorInterval / 60000L + "] minutes";
            } else {
                this.fDirectivesBehavior = this.fHeartbeat.addBehavior((ITimestampedRunnable)directivesBehavior, kDynamicInstrumentBehaviorName, true, this.kBehaviorInterval, false, this.fExecutionCount);
                msg = "Will run [" + this.fExecutionCount + "] times after every [" + this.kBehaviorInterval / 60000L + "] minutes";
            }
            this.fFeedback.info(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Multiple_Inheritance_Enabled", msg));
        }
    }

    private void checkInterfaces() {
        boolean changeSettings = false;
        DGCompilerSettings compilerSettings = this.fAutoProbe.getCompilerSettings();
        ClassRepository classRepository = new ClassRepository(this.fInstrumentation);
        CompilerSettingsBuilder settingsBuilder = new CompilerSettingsBuilder(this.fFeedback, this.fLog, this.fLocalizer, compilerSettings);
        ClassMatcherRepository matcherRepository = new ClassMatcherRepository(settingsBuilder, classRepository, this.fFeedback);
        Map classMatcherMap = matcherRepository.getClassMappings();
        Class[] allClasses = this.fInstrumentation.getAllLoadedClasses();
        this.fFeedback.debug("All loaded classes ->" + allClasses.length);
        int i = 0;
        while (i < allClasses.length) {
            Class cls = allClasses[i];
            if (cls != null && !cls.isInterface() && !cls.isArray()) {
                for (Class intf : classMatcherMap.keySet()) {
                    if (!intf.isAssignableFrom(cls) || intf.getName().equals(cls.getName())) continue;
                    List mappingList = (List)classMatcherMap.get(intf);
                    boolean foundUninstrumentedClass = this.checkForInterface(mappingList, cls, intf);
                    if (changeSettings || !foundUninstrumentedClass) continue;
                    changeSettings = true;
                }
            }
            ++i;
        }
        if (changeSettings && !this.fDisableDirectivesChange) {
            try {
                Iterator finalItr = settingsBuilder.getTracerIterator();
                while (finalItr.hasNext()) {
                    MethodTracerBuilder tracerBuilder = (MethodTracerBuilder)finalItr.next();
                    IClassMatcher classMatcher = tracerBuilder.getClassMatcher();
                    if (!(classMatcher instanceof DGCompoundClassMatcher)) continue;
                    classMatcher = ((DGCompoundClassMatcher)classMatcher).IClassMatcher_generateImmutableMatcher();
                }
                this.fFeedback.debug("Generating new settings");
                DGCompilerSettings newCompilerSettings = settingsBuilder.generateSettings(this.fLog);
                this.fFeedback.debug("refreshing new settings on autoprobe config");
                this.fAutoProbe.setDGCompilerSettings(compilerSettings, newCompilerSettings);
            }
            catch (ValidationException e) {
                this.fFeedback.debug("error generating compiler settings", (Throwable)e);
            }
        }
    }

    private boolean checkForInterface(List mappingList, Class cls, Class intf) {
        boolean globalMatch = false;
        RuntimeModeledClass modeledClass = new RuntimeModeledClass(cls, this.fFeedback);
        int i = 0;
        while (i < mappingList.size()) {
            ClassMatcherTracerGroupMapping mapping = (ClassMatcherTracerGroupMapping)mappingList.get(i);
            TracerGroupBuilder tracerGroup = mapping.getTracerGroupBuilder();
            DGCompoundClassMatcher classMatcher = mapping.getClassMatcher();
            if (!classMatcher.IClassMatcher_matches((IModeledClass)modeledClass)) {
                this.fFeedback.debug("Class Name ->" + cls.getName() + " needs updated instrumentation - for interface/superclass ->" + intf.getName());
                this.logFirstInstance();
                globalMatch = true;
                try {
                    this.fFeedback.debug("Directives change enabled -" + this.fDisableDirectivesChange);
                    DGExactClassMatcher exactClassMatcher = new DGExactClassMatcher((IClassName)ClassName.getClassName((String)cls.getName()));
                    classMatcher.addClassMatcher((IClassMatcher)exactClassMatcher);
                }
                catch (InvalidClassNameException e) {
                    this.fFeedback.debug("Could not generate class name -" + cls, (Throwable)e);
                }
                if (tracerGroup != null) {
                    if (!this.fDisableLogging) {
                        this.fFeedback.debug("logging directive for class -" + cls.getName());
                        String logMessage = this.generateLogMessage(cls, intf, tracerGroup);
                        this.fFeedback.debug("directive generated -" + logMessage);
                        this.customChannel.info(logMessage);
                    }
                } else {
                    this.fFeedback.debug("No Tracer group found for interface/superclass " + intf.getName() + " no directive being generated/logged.");
                }
            }
            ++i;
        }
        return globalMatch;
    }

    private void logFirstInstance() {
        if (!this.kLoggedDirectiveChangeMessage) {
            this.fFeedback.info(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Missing_Directive_Message", ""));
            if (!this.fDisableLogging) {
                this.fFeedback.info(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Directive_Being_Logged_Message", ""));
            }
            this.kLoggedDirectiveChangeMessage = true;
        }
    }

    private String generateLogMessage(Class cls, Class intf, TracerGroupBuilder tracerGroup) {
        StringBuilder sb = new StringBuilder();
        sb.append("IdentifyClassAs:");
        sb.append(kWhiteSpace);
        sb.append(cls.getName());
        sb.append(kWhiteSpace);
        sb.append(kWhiteSpace);
        sb.append(tracerGroup.getName());
        return sb.toString();
    }

    private final class MultipleInheritanceBehavior
    implements ITimestampedRunnable {
        private MultipleInheritanceBehavior() {
        }

        public void ITimestampedRunnable_execute(long nowInMillis) {
            MultipleInheritanceHandler.this.checkInterfaces();
        }
    }
}

