/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.cas;

import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.EndTransactionElement;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionElementProvider;
import com.wily.introscope.agent.trace.cas.TransactionTransitionException;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.introscope.agent.trace.hc2.AImmutableBlameComponent;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.agent.trace.intelligent.AutoTracingController;
import com.wily.introscope.agent.trace.intelligent.DiscoveryTracingEnabledProperty;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractTransactionElement
implements ITransactionElement {
    protected volatile boolean fIsNotValid;
    private final short fDepth;
    public final AtomicLong lastTouched = new AtomicLong(System.currentTimeMillis());
    public final AtomicLong lastRead = new AtomicLong(0L);
    public static final ABlameComponent kEndKey = AImmutableBlameComponent.getImmutableInstance("End");
    public static final String discoveryTraceText = "New transaction path discovered";
    private AtomicInteger fAgingCount = new AtomicInteger(0);
    private AtomicInteger fDiscoveryTraceAgingCounter = new AtomicInteger(0);
    private volatile int fAppMapAgingStamp = 0;
    private int fAgentFeatureIndicant;
    protected final AtomicReference fEndTransactionChild = new AtomicReference();
    public static final ITransactionElementProvider kEndTransactionElementProvider = new ITransactionElementProvider(){

        @Override
        public ITransactionElement getElement(Object key, ITransactionElement parent) {
            return new EndTransactionElement(parent);
        }

        @Override
        public ITransactionElement getElementOnStartTrace(Object key, int tracerIndex, IStackElement data, ITransactionElement parent) {
            throw new Error("Cannot be invoked on start trace");
        }

        @Override
        public ITransactionElement getElementOnEndTrace(Object key, int tracerIndex, IStackElement data, ITransactionElement parent) {
            return new EndTransactionElement(parent);
        }
    };
    private final ITransactionElement fParent;
    private final boolean fIsStartTrace;
    private volatile boolean fIsEndTrace = false;

    public AbstractTransactionElement(ITransactionElement parent, boolean isStartTrace) {
        this.fParent = parent;
        this.fIsStartTrace = isStartTrace;
        this.fDepth = WilyTransactionStructure.getDepth(parent);
    }

    @Override
    public ITransactionElement getParent() {
        return this.fParent;
    }

    public boolean isStartTrace() {
        return this.fIsStartTrace;
    }

    public void setEndTrace(boolean fIsEndTrace) {
        this.fIsEndTrace = fIsEndTrace;
    }

    public boolean isEndTrace() {
        return this.fIsEndTrace;
    }

    @Override
    public final ITransactionElement touch(long now) {
        this.lastTouched.set(now);
        return this;
    }

    @Override
    public final ITransactionElement touch() {
        this.lastTouched.set(System.currentTimeMillis());
        return this;
    }

    @Override
    public void markReadTime(long readTime) {
        this.lastRead.set(readTime);
    }

    @Override
    public long lastTouched() {
        return this.lastTouched.get();
    }

    @Override
    public boolean wasTouchedSinceLastReadTime() {
        boolean result;
        long lastTouchedValue = this.lastTouched.get();
        long lastReadValue = this.lastRead.get();
        boolean bl = result = lastReadValue < lastTouchedValue;
        if (this.lastTouched.compareAndSet(lastTouchedValue, lastTouchedValue) && this.lastRead.compareAndSet(lastReadValue, lastReadValue)) {
            return result;
        }
        return true;
    }

    @Override
    public long getFilterEnablerBit() {
        return 0L;
    }

    public void markTransactionElementForDiscoveryTrace(IStackElement data, ITransactionElement element) {
        if (DiscoveryTracingEnabledProperty.discoveryTracingEnabled) {
            this.markTransactionForDiscoveryTrace(data, element);
        }
        int agingCounter = WilyTransactionStructure.getInstance().getAppMapAgingCounter();
        int localCounter = this.fDiscoveryTraceAgingCounter.get();
        this.fDiscoveryTraceAgingCounter.compareAndSet(localCounter, agingCounter);
    }

    public void needToSendDiscoveryTraceAgain(IStackElement data, ITransactionElement element) {
        if (DiscoveryTracingEnabledProperty.discoveryTracingEnabled) {
            int agingCounter = WilyTransactionStructure.getInstance().getAppMapAgingCounter();
            int localCounter = this.fDiscoveryTraceAgingCounter.get();
            if (localCounter != agingCounter && this.fDiscoveryTraceAgingCounter.compareAndSet(localCounter, agingCounter)) {
                this.markTransactionForDiscoveryTrace(data, element);
            }
        }
    }

    private void markTransactionForDiscoveryTrace(IStackElement data, ITransactionElement element) {
        if (data != null && !data.isMarkedForDiscoveryTrace() && element instanceof IBlameTransactionElement && data instanceof InvocationData) {
            AutoTracingController.markForAutoTracing((InvocationData)data, discoveryTraceText, ((IBlameTransactionElement)element).getComponentName());
            data.setMarkedForDiscoveryTrace(true);
        }
    }

    public boolean needToSendAppMapAgain(int currentCounter) {
        int stamp = this.fAppMapAgingStamp;
        if (stamp != currentCounter) {
            this.fAppMapAgingStamp = currentCounter;
            return true;
        }
        return false;
    }

    @Override
    public void resetAppMapStamp() {
        this.fAppMapAgingStamp = 0;
    }

    @Override
    public final ITransactionElement goToChildEndTransaction(Object key, int tracerIndex, IStackElement data, ITransactionElementProvider provider) {
        ITransactionElement e = (ITransactionElement)this.fEndTransactionChild.get();
        if (e != null) {
            if (this.needToSendAppMapAgain(WilyTransactionStructure.getInstance().getAppMapAgingCounter()) && data instanceof InvocationData) {
                ((InvocationData)data).setHasNewCursor();
            }
            return e;
        }
        AbstractTransactionElement.checkCount(provider, key, tracerIndex, data, this);
        e = provider.getElementOnEndTrace(key, tracerIndex, data, this);
        if (!this.fEndTransactionChild.compareAndSet(null, e)) {
            return this.goToChildEndTransaction(key, tracerIndex, data, provider);
        }
        e.notifyPublished();
        return e;
    }

    public int increaseAgingCount() {
        return this.fAgingCount.incrementAndGet();
    }

    public void resetAgingCount() {
        this.fAgingCount.set(0);
    }

    @Override
    public boolean isNotValid() {
        return this.fIsNotValid;
    }

    protected void invalidate() {
        this.fIsNotValid = true;
    }

    public static void checkCount(ITransactionElementProvider provider, Object key, int tracerIndex, IStackElement data, ITransactionElement transactionElement) throws TransactionTransitionException {
        if (!WilyTransactionStructure.getInstance().notifyNewElement(provider, key, tracerIndex, data, transactionElement)) {
            throw new TransactionTransitionException("Max count of Transaction element reached");
        }
    }

    @Override
    public short getDepth() {
        return this.fDepth;
    }

    @Override
    public int getAgentFeatureIndicant() {
        return this.fAgentFeatureIndicant;
    }

    @Override
    public void setAgentFeatureIndicant(int fAgentFeatureIndicant) {
        this.fAgentFeatureIndicant = fAgentFeatureIndicant;
    }
}

