/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.io;

import com.wily.introscope.agent.IAgent;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.HostSetConfigurationProperty;
import com.wily.util.properties.hot.IntegerSetConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class SocketConfiguration {
    private static final SocketConfiguration instance = new SocketConfiguration();
    public static final int SOCKET_CLIENT_HOSTS = 0;
    public static final int SOCKET_CLIENT_PORTS = 1;
    public static final int SOCKET_SERVER_PORTS = 2;
    private final String[] paramNames = new String[]{"introscope.agent.io.socket.client.hosts", "introscope.agent.io.socket.client.ports", "introscope.agent.io.socket.server.ports"};
    private final String[] paramDescriptions = new String[]{"IO_Socket_Client_Hosts", "IO_Socket_Client_Ports", "IO_Socket_Server_Ports"};
    private final AtomicReferenceArray<Set<Object>> paramSets = new AtomicReferenceArray(3);
    private static AtomicBoolean kIsRequiredComputationEnabled = new AtomicBoolean();

    public static SocketConfiguration getSocketConfiguration(IAgent agent) {
        return instance;
    }

    private SocketConfiguration() {
        int i = 0;
        while (i < 3) {
            this.paramSets.set(i, null);
            ++i;
        }
    }

    public static void setAgent(IAgent agent) {
        instance.setAgentInternal(agent);
    }

    private void setAgentInternal(IAgent agent) {
        ConfigurationManager cm = agent.IAgent_getConfigurationManager();
        Module module = agent.IAgent_getModule();
        IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
        IStringLocalizer localizer = agent.IAgent_getStringLocalizer();
        cm.add(new SocketHostSetConfigurationProperty(0, this.paramNames[0], this.paramDescriptions[0], feedback, module, localizer), true);
        int i = 1;
        while (i < 3) {
            cm.add(new SocketIntegerSetConfigurationProperty(i, this.paramNames[i], this.paramDescriptions[i], feedback, module, localizer), true);
            ++i;
        }
    }

    public boolean isRequired(int i, Object o) {
        Set<Object> required = null;
        required = this.paramSets.get(i);
        if (required == null || required.size() == 0) {
            return true;
        }
        return required.contains(o);
    }

    public boolean isRequiredEnabled() {
        return kIsRequiredComputationEnabled.get();
    }

    private boolean hasFilteringConfiguration() {
        Set<Object> required = null;
        boolean isFilteringSet = false;
        int i = 0;
        while (i < 3) {
            required = this.paramSets.get(i);
            if (required != null && required.size() > 0) {
                isFilteringSet = true;
                break;
            }
            ++i;
        }
        return isFilteringSet;
    }

    private final class SocketHostSetConfigurationProperty
    extends HostSetConfigurationProperty {
        private final int setIndex;

        private SocketHostSetConfigurationProperty(int setIndex, String propName, String propDescription, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
            super(propName, propDescription, feedback, module, localizer);
            this.setIndex = setIndex;
        }

        @Override
        public final void set(Object value) {
            Set cv = (Set)value;
            SocketConfiguration.this.paramSets.set(this.setIndex, cv == null || cv.size() == 0 ? null : cv);
            boolean isFilteringSet = SocketConfiguration.this.hasFilteringConfiguration();
            kIsRequiredComputationEnabled.set(isFilteringSet);
        }
    }

    private final class SocketIntegerSetConfigurationProperty
    extends IntegerSetConfigurationProperty {
        private final int setIndex;

        private SocketIntegerSetConfigurationProperty(int setIndex, String propName, String propDescription, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
            super(propName, propDescription, feedback, module, localizer);
            this.setIndex = setIndex;
        }

        @Override
        public final void set(Object value) {
            Set cv = (Set)value;
            SocketConfiguration.this.paramSets.set(this.setIndex, cv == null || cv.size() == 0 ? null : cv);
            boolean isFilteringSet = SocketConfiguration.this.hasFilteringConfiguration();
            kIsRequiredComputationEnabled.set(isFilteringSet);
        }
    }
}

