/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.stat.gatherer;

import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.gatherer.ALongCombiningGatherer;
import com.wily.introscope.stat.timeslice.LongTimeslicedValue;
import com.wily.wilyassert.Assertion;

public class LongFluctuatingMinGatherer
extends ALongCombiningGatherer {
    private long fValue;
    private long fMax;
    private long fMin;
    private boolean fReset;

    public LongFluctuatingMinGatherer(int typeCookie, long startTimestamp) {
        super(typeCookie, startTimestamp);
        this.whackInternalState();
        Assertion.wilyAssert(false);
    }

    @Override
    public long getLongValue() {
        return this.fValue;
    }

    @Override
    public long getLongMinimum() {
        return this.fMin;
    }

    @Override
    public long getLongMaximum() {
        return this.fMax;
    }

    @Override
    protected void directSetLongMinimum(long minimum) {
        this.fMin = minimum;
    }

    @Override
    protected void directSetLongMaximum(long maximum) {
        this.fMax = maximum;
    }

    public synchronized void recordOneDataPoint(int value) {
        this.updateWithData(value);
        this.syncSinglePointBounds(value);
        this.incrementDataPointCountNonSync();
        this.noteDataIsPresent();
    }

    private void updateWithData(long value) {
        if (this.fReset) {
            this.fValue = Long.MAX_VALUE;
            this.fReset = false;
        }
        if (value < this.fValue) {
            this.fValue = value;
        }
    }

    @Override
    protected void doAcceptAggregateLongTimeslicedValue(LongTimeslicedValue typedAggregate) {
        long count = typedAggregate.getDataPointCount();
        long value = typedAggregate.getValue();
        this.updateWithData(value);
        this.addToDataPointCount(count);
        this.syncAggregateBounds(typedAggregate);
    }

    @Override
    protected void doResetCombiningGatherer(long when) {
        this.directSetLongMaximum(this.fValue);
        this.directSetLongMinimum(this.fValue);
        this.fReset = true;
    }

    @Override
    protected void doReinitializeCombiningGatherer() {
        this.whackInternalState();
    }

    private void whackInternalState() {
        this.directSetLongMaximum(0L);
        this.directSetLongMinimum(0L);
        this.fValue = 0L;
        this.fReset = true;
    }

    public static IMetricDataValue aggregateByTime(IMetricDataValue pvalue1, IMetricDataValue pvalue2) {
        LongTimeslicedValue value1 = (LongTimeslicedValue)pvalue1;
        LongTimeslicedValue value2 = (LongTimeslicedValue)pvalue2;
        if (value1.dataIsAbsent() || value2.dataIsAbsent()) {
            return LongFluctuatingMinGatherer.absentLong(value1, value2);
        }
        long count = value1.getDataPointCount() + value2.getDataPointCount();
        long min = Math.min(value1.getMinimum(), value2.getMinimum());
        long max = Math.max(value1.getMaximum(), value2.getMaximum());
        long value = Math.min(value1.getValue(), value2.getValue());
        return new LongTimeslicedValue(value1.getType(), value1.getStartTimestampInMillis(), value2.getStopTimestampInMillis(), null, count, false, value, min, max);
    }
}

