/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.transform;

import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.diagnos.cmp.directives.apply.ClassSettingsApplier;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.diagnos.cmp.methodmatcher.InstanceConstructorMethodMatcher;
import com.wily.diagnos.cmp.mutate.IMethodMutator;
import com.wily.diagnos.cmp.mutate.IMutation;
import com.wily.diagnos.cmp.transform.AEveryMethodTransformation;
import com.wily.diagnos.cmp.transform.builder.ITransformationBuilder;
import com.wily.diagnos.cmp.transform.builder.NoticeConstructorCompletionTransformationBuilder;
import com.wily.util.classfile.FullyQualifiedMethodName;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;

public final class NoticeConstructorCompletionTransformation
extends AEveryMethodTransformation {
    private final TracerGroup fTracerGroup;
    private final FullyQualifiedMethodName fNotificationMethod;
    private final IMethodMatcher fMethodMatcher;

    public NoticeConstructorCompletionTransformation(ICompilerLog log, FullyQualifiedMethodName notificationMethod) {
        this(log, null, notificationMethod);
    }

    public NoticeConstructorCompletionTransformation(ICompilerLog log, TracerGroup tracerGroup, FullyQualifiedMethodName notificationMethod) {
        super(log);
        this.fTracerGroup = tracerGroup;
        this.fNotificationMethod = notificationMethod;
        this.fMethodMatcher = new InstanceConstructorMethodMatcher();
    }

    public TracerGroup getTracerGroup() {
        return this.fTracerGroup;
    }

    public FullyQualifiedMethodName getNotificationMethod() {
        return this.fNotificationMethod;
    }

    @Override
    protected boolean doShouldProcessClass(DGCompilerSettings settings, IModeledClass targetClass) {
        return !ClassSettingsApplier.shouldSkipClassForTracerGroup(this.getLog(), targetClass, this.getTracerGroup()) && this.getTracerGroup().getClassMatcher().IClassMatcher_matches(targetClass);
    }

    @Override
    protected boolean doShouldMutateMethod(DGCompilerSettings settings, IModeledMethod targetMethod) {
        return this.fMethodMatcher.IMethodMatcher_matches(targetMethod) && targetMethod.hasBytecode();
    }

    @Override
    protected IMutation doGenerateMethodMutation(DGCompilerSettings settings, IMethodMutator mutator, IModeledMethod targetMethod) {
        return mutator.newNoticeConstructorCompletionMethodMutation(settings, targetMethod, this);
    }

    @Override
    public ITransformationBuilder generateTransformationBuilder(CompilerSettingsBuilder builder) {
        return new NoticeConstructorCompletionTransformationBuilder(builder.getTracerGroupBuilder(this.getTracerGroup()), this.getNotificationMethod());
    }
}

