/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.async;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.async.AsyncFrontendStartTracer;
import com.wily.introscope.agent.blame.ApplicationNameInfo;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.introscope.agent.trace.hc2.HttpRequestLazyMap;
import com.wily.introscope.agent.trace.hc2.HttpRequestLazyMapProvider;
import com.wily.introscope.agent.trace.hc2.HttpServletLazyMap;
import com.wily.introscope.agent.trace.hc2.HttpServletLazyMapProvider;
import com.wily.introscope.agent.trace.hc2.UrlGroupingProvider;
import com.wily.introscope.agent.trace.servlet.IHttpRequestHelper;
import com.wily.introscope.agent.trace.servlet.IServletRequestHelper;
import com.wily.introscope.agent.trace.servlet.LoaderContext;
import com.wily.introscope.agent.transactiontrace.CorrelationService;
import com.wily.introscope.agent.transactiontrace.ICorrelationParameterProvider;
import com.wily.introscope.spec.agent.bizdef.IBizTrx;
import com.wily.util.adt.CanonicalObjectPool;
import com.wily.util.properties.AttributeListing;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public abstract class AsyncHttpFrontendStartTracer
extends AsyncFrontendStartTracer {
    private static int sCompNameErrorCount = 0;
    private static final int sCompNameConsecutiveErrorThreshold = 100;
    private final String charEncoding;
    protected static boolean sHaveGivenUpGettingCompName = false;

    public AsyncHttpFrontendStartTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.charEncoding = agent.IAgent_getIndexedProperties().getProperty("introscope.agent.charEncoding");
    }

    protected abstract IHttpRequestHelper getHttpRequestHelper(InvocationData var1);

    protected abstract Object getHttpRequestObject(InvocationData var1);

    protected String getApplicationName(InvocationData data) {
        return null;
    }

    @Override
    protected Object getBlameKey(InvocationData data) {
        String component = this.getComponentName(data);
        if (data.getInvocationParameterCount() > 0) {
            IBizTrx bixTrxKey = (IBizTrx)data.get("BusinessTrxData");
            if (bixTrxKey == null) {
                return component;
            }
            long bizTrxKeyId = bixTrxKey.getId();
            ABlameComponent key = ABlameComponent.getArrayInstance(new Object[]{component, bixTrxKey}, bizTrxKeyId);
            return key;
        }
        return component;
    }

    @Override
    protected String getFrontendNameForAsyncComponent(InvocationData data, String rootName) {
        String result;
        block11: {
            result = null;
            if (!sHaveGivenUpGettingCompName) {
                Object request = this.getHttpRequestObject(data);
                IHttpRequestHelper helper = this.getHttpRequestHelper(data);
                if (request != null) {
                    try {
                        HashMap parameterMap = new HashMap();
                        String url = UrlGroupingProvider.getNormalizedURL(this.agent, parameterMap, helper, request, data, this.charEncoding);
                        String rawUrl = UrlGroupingProvider.getURL(this.agent, helper, request);
                        String tracerAppName = this.getApplicationName(data);
                        String appName = ApplicationNameInfo.resolveApplicationName(tracerAppName);
                        data.put("Application Name", appName);
                        data.put("Context Path", url);
                        data.put("URL", rawUrl);
                        StringBuilder sb = new StringBuilder();
                        String prefix = String.valueOf(this.getFormattedName()) + "|";
                        if (!prefix.contains("Frontends")) {
                            prefix = "Frontends|Apps|";
                        }
                        sb.append(prefix);
                        sb.append(appName);
                        sb.append("|URLs|");
                        sb.append(url);
                        result = sb.toString();
                        sCompNameErrorCount = 0;
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable t) {
                        try {
                            this.getModuleFeedback().error("An error occurred while formatting HTTP frontend metrics: " + t);
                            this.getModuleFeedback().verbose(t);
                        }
                        catch (ThreadDeath td2) {
                            throw td2;
                        }
                        catch (Throwable throwable) {}
                        if (++sCompNameErrorCount < 100) break block11;
                        sHaveGivenUpGettingCompName = true;
                    }
                }
            }
        }
        if (result == null) {
            result = this.formatParameterizedName(data);
        }
        return CanonicalObjectPool.getCanonicalString(result);
    }

    protected void setHttpSupport(InvocationData data, IHttpRequestHelper helper, Object request) {
        if (!data.hasServletSupport() && request != null) {
            HashMap cacheParameterMap = new HashMap();
            HashMap supportMap = new HashMap();
            if (helper instanceof IServletRequestHelper) {
                IServletRequestHelper servletHelper = (IServletRequestHelper)helper;
                Object servlet = data.getInvocationObject();
                LoaderContext context = LoaderContext.getContext("AsyncHttpServletTracerHC");
                HttpServletLazyMapProvider provider = new HttpServletLazyMapProvider(servlet, data, this.agent, cacheParameterMap, servletHelper, this.charEncoding, context, request);
                HttpServletLazyMap map = new HttpServletLazyMap(this.getAgent(), servletHelper, request, servlet, provider, supportMap, context.getAccessoryKeys());
                data.setServletSupport(request, servlet, servletHelper, context, cacheParameterMap, provider, map);
            } else {
                HttpRequestLazyMapProvider provider = new HttpRequestLazyMapProvider(request, data, this.agent, cacheParameterMap, helper, this.charEncoding);
                HttpRequestLazyMap map = new HttpRequestLazyMap(this.getAgent(), helper, request, provider, supportMap, new HashSet());
                data.setServletSupport(request, null, helper, null, cacheParameterMap, provider, map);
            }
        }
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        String appname;
        String tenant;
        String sdk;
        String connection;
        String os;
        String device;
        String location;
        String carrier;
        IBizTrx bizTrx;
        String rawUrl;
        String url;
        final Object request = this.getHttpRequestObject(data);
        final IHttpRequestHelper helper = this.getHttpRequestHelper(data);
        CorrelationService.getInstance().getCorrelationId(data, new ICorrelationParameterProvider(){

            @Override
            public String getCorrelationParameter(String name) {
                String correlationString = helper.getHeader(request, name);
                return correlationString;
            }

            @Override
            public Map<String, String> getCorrelationParameterMap() {
                Enumeration<String> names = helper.getHeaderNames(request);
                HashMap<String, String> result = new HashMap<String, String>();
                while (names.hasMoreElements()) {
                    String name = names.nextElement();
                    result.put(name, helper.getHeader(request, name));
                }
                return result;
            }
        }, true);
        this.setHttpSupport(data, helper, request);
        super.ITracer_startTrace(tracerIndex, data);
        String appName = (String)data.get("Application Name");
        if (appName != null) {
            this.asyncStack.decorateComponentWithParam(data, "Application Name", appName, "Frontend component");
        }
        if ((url = (String)data.get("Context Path")) != null) {
            this.asyncStack.decorateComponentWithParam(data, "Context Path", url, "Frontend component");
        }
        if ((rawUrl = (String)data.get("URL")) != null) {
            this.asyncStack.decorateComponentWithParam(data, "URL", url, "Frontend component");
        }
        if ((bizTrx = (IBizTrx)data.get("BusinessTrxData")) != null) {
            String bizTrxName;
            String bizName = bizTrx.getBizFullName();
            if (bizName != null) {
                this.asyncStack.decorateComponentWithParam(data, "Business Definition", bizName, "Frontend component");
            }
            if ((bizTrxName = bizTrx.getBizTrxName()) != null) {
                this.asyncStack.decorateComponentWithParam(data, "EUM Business Transaction", bizTrxName, "Frontend component");
            }
        }
        if ((carrier = (String)data.get("x-apm-bt.Carrier")) != null) {
            this.asyncStack.decorateComponentWithParam(data, "x-apm-bt.Carrier", carrier, "Frontend component");
        }
        if ((location = (String)data.get("x-apm-bt.Location")) != null) {
            this.asyncStack.decorateComponentWithParam(data, "x-apm-bt.Location", location, "Frontend component");
        }
        if ((device = (String)data.get("x-apm-bt.Device")) != null) {
            this.asyncStack.decorateComponentWithParam(data, "x-apm-bt.Device", device, "Frontend component");
        }
        if ((os = (String)data.get("x-apm-bt.OS Version")) != null) {
            this.asyncStack.decorateComponentWithParam(data, "x-apm-bt.OS Version", os, "Frontend component");
        }
        if ((connection = (String)data.get("x-apm-bt.Connection")) != null) {
            this.asyncStack.decorateComponentWithParam(data, "x-apm-bt.Connection", connection, "Frontend component");
        }
        if ((sdk = (String)data.get("x-apm-bt.Identifier Version")) != null) {
            this.asyncStack.decorateComponentWithParam(data, "x-apm-bt.Identifier Version", sdk, "Frontend component");
        }
        if ((tenant = (String)data.get("x-apm-bt.Tenant")) != null) {
            this.asyncStack.decorateComponentWithParam(data, "x-apm-bt.Tenant", tenant, "Frontend component");
        }
        if ((appname = (String)data.get("x-apm-bt.Application Name")) != null) {
            this.asyncStack.decorateComponentWithParam(data, "x-apm-bt.Application Name", appname, "Frontend component");
        }
    }
}

