/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.IIntelligentInstrumentationFilter;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligentErrorSnapshotFilter;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligentTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;

public class HighPerformanceIntelligentFilter
implements IIntelligentInstrumentationFilter {
    private static volatile IAgent fAgent = null;
    private static HighPerformanceIntelligentFilter fFilter = null;
    private static HighPerformanceIntelligentTransactionTraceFilter fTransactionTraceFilter = null;
    private static HighPerformanceIntelligentErrorSnapshotFilter fErrorTraceFilter = null;
    private static boolean fInitialized = false;

    static {
        try {
            fAgent = AgentShim.getAgent();
            fFilter = new HighPerformanceIntelligentFilter();
            fTransactionTraceFilter = HighPerformanceIntelligentTransactionTraceFilter.getInstance();
            fErrorTraceFilter = HighPerformanceIntelligentErrorSnapshotFilter.getInstance();
            if (fAgent != null) {
                HighPerformanceIntelligentFilter.initialize();
            }
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
    }

    private HighPerformanceIntelligentFilter() {
    }

    public static boolean isInitialized() {
        return fInitialized;
    }

    public static void initialize() {
        if (fInitialized) {
            return;
        }
        IAgent agent = HighPerformanceIntelligentFilter.getAgent();
        if (agent != null) {
            agent.addEventListener(fFilter);
            fTransactionTraceFilter.initialize(agent);
            fErrorTraceFilter.initialize(agent);
            fInitialized = true;
        }
    }

    public static HighPerformanceIntelligentFilter getInstance() {
        return fFilter;
    }

    @Override
    public void noticeEvent(TransactionComponentData root) {
        IAgent agent = HighPerformanceIntelligentFilter.getAgent();
        String eventType = root.getParameterValue("Trace Type");
        if (eventType.equals("Normal") || eventType.equals("Sampled")) {
            fTransactionTraceFilter.updateTransactionCounter(agent, root, HighPerformanceIntelligentFilter.getTotalComponentsFromTCD(root));
        } else if (eventType.equals("ErrorSnapshot")) {
            fErrorTraceFilter.updateErrorCounter(agent, root, HighPerformanceIntelligentFilter.getTotalComponentsFromTCD(root));
        }
    }

    @Override
    public int getTransactionTraceThrottleState() {
        return fTransactionTraceFilter.getTransactionTraceThrottleState();
    }

    @Override
    public int getSingleTransactionTraceComponentsMax() {
        return fTransactionTraceFilter.getSingleTransactionTraceComponentsMax();
    }

    public int getTransactionTraceMaxDepth() {
        return fTransactionTraceFilter.getMaxTransactionDepth();
    }

    @Override
    public int getTransactionResponseThresholdFactor() {
        return fTransactionTraceFilter.getTransactionResponseThresholdFactor();
    }

    @Override
    public int getErrorSnapshotThrottleState() {
        return fErrorTraceFilter.getErrorSnapshotThrottleState();
    }

    @Override
    public int getSingleErrorSnapshotComponentsMax() {
        return fErrorTraceFilter.getSingleErrorSnapshotComponentsMax();
    }

    public static IAgent getAgent() {
        if (fAgent == null) {
            try {
                fAgent = AgentShim.getAgent();
            }
            catch (Exception exception) {}
        }
        return fAgent;
    }

    public static void logMessageDebug(String errorMessage, Throwable th) {
        IAgent agent = HighPerformanceIntelligentFilter.getAgent();
        if (agent != null && agent.IAgent_getModuleFeedback().isDebugEnabled()) {
            agent.IAgent_getModuleFeedback().debug(errorMessage);
        }
    }

    public static int getTotalComponentsFromTCD(TransactionComponentData root) {
        String totalComponentsStr = root.getParameterValue("Total Methods");
        int totalComponents = 1;
        if (totalComponentsStr != null && totalComponentsStr.trim().length() > 0) {
            try {
                totalComponents = Integer.parseInt(totalComponentsStr);
            }
            catch (NumberFormatException ex) {
                HighPerformanceIntelligentFilter.logMessageDebug("getTotalComponentsFromTCD() cannot find total Components. totalComponentsStr: " + totalComponentsStr, ex);
            }
        }
        return totalComponents;
    }
}

