/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt.trie;

import com.wily.util.adt.trie.TrieNode;
import java.util.Iterator;
import java.util.Map;

public class Trie {
    private TrieNode root = new TrieNode();
    private int memberCount = 0;

    public TrieNode getRoot() {
        return this.root;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public void insert(String word) {
        TrieNode current = this.root;
        int i = 0;
        int n = word.length();
        while (i < n) {
            char temp = word.charAt(i);
            Map<Character, TrieNode> children = current.getChildrenForInsert();
            if ((current = children.get(Character.valueOf(temp))) == null) {
                current = new TrieNode();
                children.put(Character.valueOf(temp), current);
            }
            ++i;
        }
        current.setEndOfWord(true);
        ++this.memberCount;
    }

    public boolean deleteEntry(String word) {
        return this.delete(this.root, word, 0);
    }

    public boolean contains(String word) {
        TrieNode current = this.root;
        int i = 0;
        while (i < word.length()) {
            Map<Character, TrieNode> children = current.getChildren();
            if (children == null) {
                return false;
            }
            char temp = word.charAt(i);
            current = children.get(Character.valueOf(temp));
            if (current == null) {
                return false;
            }
            ++i;
        }
        return current.isEndOfWord();
    }

    public boolean isEmpty() {
        return this.root.getChildren() == null;
    }

    private boolean delete(TrieNode current, String word, int index) {
        boolean shouldDeleteCurrentNode;
        Map<Character, TrieNode> children = current.getChildren();
        if (index == word.length()) {
            if (!current.isEndOfWord()) {
                return false;
            }
            current.setEndOfWord(false);
            --this.memberCount;
            return children == null || children.isEmpty();
        }
        if (children == null) {
            return false;
        }
        char temp = word.charAt(index);
        TrieNode child = children.get(Character.valueOf(temp));
        if (child == null) {
            return false;
        }
        boolean bl = shouldDeleteCurrentNode = this.delete(child, word, index + 1) && !child.isEndOfWord();
        if (shouldDeleteCurrentNode) {
            children.remove(Character.valueOf(temp));
            if (children.isEmpty()) {
                current.setChildrenToNull();
                return true;
            }
        }
        return false;
    }

    public void merge(Trie other) {
        this.mergeTries(this.getRoot(), other.getRoot());
        this.memberCount += other.getMemberCount();
    }

    private void mergeTries(TrieNode thisTrie, TrieNode otherTrie) {
        if (otherTrie.isEndOfWord()) {
            if (thisTrie.isEndOfWord()) {
                --this.memberCount;
            } else {
                thisTrie.setEndOfWord(true);
            }
        }
        if (otherTrie.getChildren() == null) {
            return;
        }
        if (thisTrie.getChildren() == null) {
            thisTrie.getChildrenForInsert().putAll(otherTrie.getChildren());
            return;
        }
        Iterator<Map.Entry<Character, TrieNode>> it = otherTrie.getChildren().entrySet().iterator();
        Map<Character, TrieNode> thisChildren = thisTrie.getChildren();
        while (it.hasNext()) {
            Map.Entry<Character, TrieNode> pair = it.next();
            if (thisChildren.containsKey(pair.getKey())) {
                this.mergeTries(thisChildren.get(pair.getKey()), pair.getValue());
                continue;
            }
            thisChildren.put(pair.getKey(), pair.getValue());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Trie)) {
            return false;
        }
        Trie trie = (Trie)o;
        return this.root != null ? this.root.equals(trie.root) : trie.root == null;
    }

    public int hashCode() {
        return this.root != null ? this.root.hashCode() : 0;
    }
}

