/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.action;

import com.wily.ui.action.AExtendedAction;
import com.wily.ui.action.ExtendedActionException;
import com.wily.util.text.SimpleLocalizableMessage;
import com.wily.wilyassert.Assertion;
import java.awt.event.ActionEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class UndoableEditExtendedAction
extends AExtendedAction {
    private static final long serialVersionUID = -6207366331018766575L;
    private UndoableEdit fUndoableEdit;

    private UndoableEditExtendedAction() {
        super(3);
        Assertion.unimplemented("must specify an UndoableEdit");
    }

    public UndoableEditExtendedAction(UndoableEdit undoableEdit) {
        super(undoableEdit.getPresentationName(), 3);
        this.initialize(undoableEdit);
    }

    private void initialize(UndoableEdit undoableEdit) {
        this.setIsConsumer(false);
        this.setIsProducer(false);
        this.setTriggered(true);
        this.fUndoableEdit = undoableEdit;
    }

    protected void doTriggerAction(ActionEvent actionEvent) throws ExtendedActionException {
        Assertion.unimplemented("doTriggerAction should never be called");
    }

    protected void doUndoAction() throws ExtendedActionException {
        try {
            this.fUndoableEdit.undo();
        }
        catch (CannotUndoException e) {
            throw new ExtendedActionException(this, e, e.getMessage(), new SimpleLocalizableMessage("Undoable_Edit_Undo_Error_Key"));
        }
    }

    protected void doRedoAction() throws ExtendedActionException {
        try {
            this.fUndoableEdit.redo();
        }
        catch (CannotRedoException e) {
            throw new ExtendedActionException(this, e, e.getMessage(), new SimpleLocalizableMessage("Undoable_Edit_Redo_Error_Key"));
        }
    }

    protected void checkCanUndo() {
        Assertion.wilyAssert(this.fUndoableEdit.canUndo());
        super.checkCanUndo();
    }

    protected void checkCanRedo() {
        Assertion.wilyAssert(this.fUndoableEdit.canRedo());
        super.checkCanRedo();
    }

    boolean mergeUndoableEdit(UndoableEdit undoableEditToMerge) {
        boolean editMerged = this.fUndoableEdit.addEdit(undoableEditToMerge);
        if (!editMerged && undoableEditToMerge.replaceEdit(this.fUndoableEdit)) {
            this.fUndoableEdit = undoableEditToMerge;
            editMerged = true;
        }
        return editMerged;
    }
}

