/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.autoprobe.dynamic;

import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.java.ClassName;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.Iterator;

public class RuntimeModeledClass
implements IModeledClass {
    private final Class fRuntimeClass;
    private IModuleFeedbackChannel fFeedback;
    private IClassName fClassName;

    public RuntimeModeledClass(Class cls, boolean initClassName, IModuleFeedbackChannel feedback) throws InvalidClassNameException {
        this.fRuntimeClass = cls;
        this.fFeedback = feedback;
        if (initClassName) {
            this.fClassName = ClassName.getClassName((String)this.fRuntimeClass.getName());
        }
    }

    public Iterator getAllDeclaredMethods() {
        throw new UnsupportedOperationException();
    }

    public boolean inheritsDirectlyFromInterface(IClassName interfaceName) {
        Class<?>[] intfs = this.fRuntimeClass.getInterfaces();
        int i = 0;
        while (i < intfs.length) {
            Class<?> intf = intfs[i];
            if (intf.getName().equals(interfaceName.getReflectionFriendlyQualifiedNameString())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Iterator getAllMethods() {
        throw new UnsupportedOperationException();
    }

    public IClassName getClassName() {
        return this.fClassName;
    }

    public IClassName getSuperClassName() {
        if (!this.hasSuperClass()) {
            return null;
        }
        try {
            return ClassName.getClassName((String)this.fRuntimeClass.getSuperclass().getName());
        }
        catch (InvalidClassNameException e) {
            this.fFeedback.debug((Throwable)e);
            return null;
        }
    }

    public boolean hasSuperClass() {
        return !this.fRuntimeClass.getSuperclass().equals(Object.class.getName());
    }

    public boolean isInterface() {
        return this.fRuntimeClass.isInterface();
    }

    public boolean isValueType() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsAnnotation(IClassName annotationName) {
        try {
            Annotation[] annotations = this.fRuntimeClass.getDeclaredAnnotations();
            int i = 0;
            while (true) {
                if (i >= annotations.length) {
                    return false;
                }
                if (annotations[i].annotationType().getName().equals(annotationName.getReflectionFriendlyQualifiedNameString())) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean referencesClass(IClassName referencedName) {
        throw new UnsupportedOperationException();
    }

    public boolean isInstanceOf(IClassName interfaceName) {
        try {
            Class<?> interfaceClass = Class.forName(interfaceName.getReflectionFriendlyQualifiedNameString(), false, this.fRuntimeClass.getClassLoader());
            return interfaceClass.isAssignableFrom(this.fRuntimeClass);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public void debugDump(PrintWriter log) {
    }
}

