/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.substituteresult.netweaver;

import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ProtocolList;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.FeatureType;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.GlobalFeatures;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.PropertyType;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.WSDMHandlerInstantiationException;
import com.wily.powerpack.webservices.handlers.netweaver.client.WSDMClientProtocol;
import java.util.Enumeration;
import java.util.Hashtable;

public class NTW6ModifyClientHandler {
    public static FeatureType getWsdmFeature() {
        return FeatureHolder.wsdmFeature;
    }

    private static GlobalFeatures prependWSDMHandler(GlobalFeatures globalFeatures, FeatureType _Feature) {
        GlobalFeatures gfeatures = globalFeatures;
        try {
            FeatureType[] _f_Feature;
            if (gfeatures == null) {
                gfeatures = new GlobalFeatures();
            }
            if ((_f_Feature = gfeatures.getFeature()) == null) {
                _f_Feature = new FeatureType[]{_Feature};
                WSMUtils.getLogger().debug("Adding Feature");
            } else {
                boolean isExists = false;
                int i = 0;
                while (i < _f_Feature.length) {
                    if (_f_Feature[i].getName().equals(_Feature.getName())) {
                        _f_Feature[i] = _Feature;
                        isExists = true;
                        WSMUtils.getLogger().debug("Feature Already Exists");
                        break;
                    }
                    ++i;
                }
                WSMUtils.getLogger().debug("Feature does not exist.Add the Feature");
                if (!isExists) {
                    FeatureType[] perm = new FeatureType[_f_Feature.length + 1];
                    System.arraycopy(_f_Feature, 0, perm, 1, _f_Feature.length);
                    perm[0] = _Feature;
                    _f_Feature = perm;
                }
            }
            gfeatures.setFeature(_f_Feature);
            NTW6ModifyClientHandler.printFeatures(gfeatures);
        }
        catch (Exception e) {
            WSMUtils.getLogger().trace(WSMUtils.getModule(), e.toString());
            return new GlobalFeatures();
        }
        return gfeatures;
    }

    public static void insertFeature(FeatureType _Feature, FeatureType[] _f_Feature) {
    }

    private static void printFeatures(GlobalFeatures gfeatures) {
        if (WSMUtils.getLogger().isDebugEnabled()) {
            WSMUtils.getLogger().debug("Start Printing Client features");
            FeatureType[] newGlobalFeatures = gfeatures.getFeature();
            int nSize = newGlobalFeatures.length;
            int i = 0;
            while (i < nSize) {
                FeatureType currentFeatureType = newGlobalFeatures[i];
                WSMUtils.getLogger().debug("FeatureType Name:" + currentFeatureType.getName());
                WSMUtils.getLogger().debug("FeatureType Protocol:" + currentFeatureType.getProvider());
                ++i;
            }
            WSMUtils.getLogger().debug("End Printing Client features");
        }
    }

    public static ProtocolList modifyProtocolList(ProtocolList globalProtocols) {
        WSDMClientProtocol wsdmClientProtocol = new WSDMClientProtocol();
        if (globalProtocols == null) {
            globalProtocols = new ProtocolList();
        }
        globalProtocols.add(0, (Object)wsdmClientProtocol);
        return globalProtocols;
    }

    public static GlobalFeatures modifyFeaturesList(GlobalFeatures globalFeatures) {
        WSMUtils.refreshLogLevels();
        GlobalFeatures newGlobalFeatures = globalFeatures;
        try {
            String message = Thread.currentThread() + " Getting Client global handler";
            WSMUtils.getLogger().debug(message);
            FeatureType wsdmFeature = NTW6ModifyClientHandler.getWsdmFeature();
            if (wsdmFeature != null) {
                newGlobalFeatures = NTW6ModifyClientHandler.prependWSDMHandler(globalFeatures, wsdmFeature);
            }
        }
        catch (ThreadDeath threadDeath) {
            return globalFeatures;
        }
        return newGlobalFeatures;
    }

    private static FeatureType getWSDMHandler(Hashtable config) throws WSDMHandlerInstantiationException {
        FeatureType featureres = null;
        PropertyType[] result = null;
        String key = null;
        int i = 0;
        try {
            featureres = new FeatureType();
            featureres.setName("http://www.ca.com/wsdmclientfeature");
            featureres.setOriginal(true);
            featureres.setProvider("WSDMClientProtocol");
            if (config != null) {
                result = new PropertyType[config.size()];
                Enumeration keys = config.keys();
                while (keys.hasMoreElements()) {
                    key = (String)keys.nextElement();
                    result[i] = new PropertyType();
                    result[i].setName(key);
                    result[i].setValue((String)config.get(key));
                    ++i;
                }
            }
            featureres.setProperty(result);
        }
        catch (ThreadDeath bomb) {
            throw bomb;
        }
        catch (Throwable bomb) {
            throw new WSDMHandlerInstantiationException(bomb);
        }
        return featureres;
    }

    private static class FeatureHolder {
        public static FeatureType wsdmFeature = null;

        static {
            try {
                wsdmFeature = NTW6ModifyClientHandler.getWSDMHandler(WSMUtils.getWSDMHandlerConfig("2"));
            }
            catch (WSDMHandlerInstantiationException e) {
                FeatureHolder.onError((Exception)((Object)e));
            }
        }

        private FeatureHolder() {
        }

        private static void onError(Exception e) {
            String message = Thread.currentThread() + " Caught unexpected exception while modifying client handlers " + e;
            WSMUtils.getLogger().error(message);
        }
    }
}

