/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;

public class EqualWidthLayout
implements LayoutManager {
    private static final int kDefaultGap = 5;
    private int fGap;

    public EqualWidthLayout() {
        this(5);
    }

    public EqualWidthLayout(int gap) {
        this.fGap = gap;
    }

    public void addLayoutComponent(String name, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        int layoutWidth = 0;
        int layoutHeight = 0;
        Component[] children = container.getComponents();
        for (int i = 0; i < children.length; ++i) {
            Dimension childSize = children[i].getPreferredSize();
            int childHeight = childSize.height;
            layoutWidth = Math.max(layoutWidth, children[i].getPreferredSize().width);
            layoutHeight += childHeight;
            if (i + 1 >= children.length) continue;
            layoutHeight += this.fGap;
        }
        Insets insets = container.getInsets();
        return new Dimension(layoutWidth += insets.left + insets.right, layoutHeight += insets.top + insets.bottom);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public void layoutContainer(Container container) {
        int i;
        Insets insets = container.getInsets();
        int childWidth = 0;
        int nextX = insets.left;
        int nextY = insets.right;
        Component[] children = container.getComponents();
        for (i = 0; i < children.length; ++i) {
            childWidth = Math.max(childWidth, children[i].getPreferredSize().width);
        }
        for (i = 0; i < children.length; ++i) {
            int childHeight = children[i].getPreferredSize().height;
            children[i].setLocation(new Point(nextX, nextY));
            children[i].setSize(childWidth, childHeight);
            nextY += childHeight + this.fGap;
        }
    }
}

