/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;

public final class ScatteringBufferInputStream
extends InputStream {
    private static final int kDefaultBufferSize = 32768;
    private final int fBuffersSize;
    private int fReadPosition;
    private BufferedData fBuffer;
    private LinkedList fBufferList;

    public ScatteringBufferInputStream() {
        this(32768);
    }

    public ScatteringBufferInputStream(int buffersSize) {
        this.fBuffersSize = buffersSize;
        this.fReadPosition = 0;
        this.fBufferList = new LinkedList();
        this.fBuffer = new BufferedData(this.fBuffersSize);
    }

    private void fill() {
        if (this.fReadPosition == this.fBuffer.getPosition()) {
            if (this.fBufferList.size() == 0) {
                this.fReadPosition = 0;
                this.fBuffer.fPosition = 0;
            } else {
                this.fBuffer = (BufferedData)this.fBufferList.removeFirst();
                this.fReadPosition = 0;
            }
        }
    }

    public final int read() {
        this.fill();
        if (this.fReadPosition == this.fBuffer.getPosition()) {
            return -1;
        }
        return this.fBuffer.getBuffer()[this.fReadPosition++] & 0xFF;
    }

    public int available() {
        int available = this.fBuffer.getPosition() - this.fReadPosition;
        Iterator i = this.fBufferList.iterator();
        while (i.hasNext()) {
            BufferedData data = (BufferedData)i.next();
            available += data.getPosition();
        }
        return available;
    }

    public boolean hasAvailable() {
        int available = this.fBuffer.getPosition() - this.fReadPosition;
        if (available > 0) {
            return true;
        }
        return this.available() > 0;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (off < 0) {
            throw new IndexOutOfBoundsException("off is negative: " + off);
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("len is negative: " + len);
        }
        int maxPos = off + len;
        if (maxPos > b.length) {
            throw new IndexOutOfBoundsException("len too large: len=" + len + ", buffer length=" + b.length + ", offset=" + off);
        }
        int pos = off;
        this.fill();
        while (pos < maxPos && this.hasAvailable()) {
            int availInBuffer = this.fBuffer.getPosition() - this.fReadPosition;
            if (availInBuffer == 0) {
                return -1;
            }
            int lenToCopy = 0;
            lenToCopy = availInBuffer > maxPos - pos ? maxPos - pos : availInBuffer;
            System.arraycopy(this.fBuffer.getBuffer(), this.fReadPosition, b, pos, lenToCopy);
            pos += lenToCopy;
            this.fReadPosition += lenToCopy;
            this.fill();
        }
        return pos - off;
    }

    public void fillFromArray(byte[] source) {
        int numRead;
        int numBytesToRead = source.length;
        BufferedData buffer = this.fBufferList.size() > 0 ? (BufferedData)this.fBufferList.getLast() : this.fBuffer;
        int pos = 0;
        for (int bytesRemaining = numBytesToRead; bytesRemaining > 0; bytesRemaining -= numRead) {
            if (buffer.freeSpaceAvailable() == 0) {
                buffer = new BufferedData(this.fBuffersSize);
                this.fBufferList.add(buffer);
            }
            int numToRead = bytesRemaining;
            numRead = buffer.fillFromArray(source, pos, numToRead);
            pos += numRead;
        }
    }

    public void fillFromStream(InputStream source) throws IOException {
        int numRead;
        int numBytesToRead = source.available();
        BufferedData buffer = this.fBufferList.size() > 0 ? (BufferedData)this.fBufferList.getLast() : this.fBuffer;
        for (int bytesRemaining = numBytesToRead; bytesRemaining > 0; bytesRemaining -= numRead) {
            if (buffer.freeSpaceAvailable() == 0) {
                buffer = new BufferedData(this.fBuffersSize);
                this.fBufferList.add(buffer);
            }
            int numToRead = Math.min(numBytesToRead, buffer.freeSpaceAvailable());
            numRead = buffer.fillFromStream(source, numToRead);
        }
    }

    int numBuffers() {
        return this.fBufferList.size() + 1;
    }

    int allBuffersSize() {
        int s = this.fBuffer.fBuffer.length;
        Iterator i = this.fBufferList.iterator();
        while (i.hasNext()) {
            s += ((BufferedData)i.next()).fBuffer.length;
        }
        return s;
    }

    private static final class BufferedData {
        int fPosition = 0;
        byte[] fBuffer;

        public BufferedData(int bufferSize) {
            this.fBuffer = new byte[bufferSize];
        }

        public int fillFromArray(byte[] source, int startIndex, int numToRead) {
            int numRead = Math.min(numToRead, this.fBuffer.length - this.fPosition);
            System.arraycopy(source, startIndex, this.fBuffer, this.fPosition, numRead);
            this.fPosition += numRead;
            return numRead;
        }

        public int fillFromStream(InputStream source, int numToRead) throws IOException {
            int numRead = source.read(this.fBuffer, this.fPosition, numToRead);
            this.fPosition += numRead;
            return numRead;
        }

        public void setPosition(int position) {
            this.fPosition = position;
        }

        public int getPosition() {
            return this.fPosition;
        }

        public void incrementPosition(int value) {
            this.fPosition += value;
        }

        public byte[] getBuffer() {
            return this.fBuffer;
        }

        public int freeSpaceAvailable() {
            return this.fBuffer.length - this.fPosition;
        }
    }
}

