/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.instrument;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.util.Date;

class JavaRedefineRetransformBean {
    public boolean fSuggestRetransform;
    public boolean fVerbose;
    public boolean fPropertyForceRedefinition;
    public boolean fPropertyForceRetransformation;
    public boolean fisJava15;
    public boolean fIsIBM;
    public boolean fForceIBM;
    public boolean fCanRetransform;
    public boolean fCanRedefine;
    public boolean fUseNullTransformer;

    JavaRedefineRetransformBean() {
    }

    private boolean isIBM1_5() {
        return this.fIsIBM && this.fisJava15;
    }

    public void checkIBM() {
        if (this.isIBM1_5() && this.fCanRedefine) {
            System.err.println("Warning: Introscope agent has been configured to support class redefinition.  1.5 IBM JVMs are known to incur significant overhead with redefinition enabled.  To avoid this overhead please use AgentNoRedef.jar instead of Agent.jar.");
        }
    }

    public String toString() {
        return "fVerbose" + " = " + this.fVerbose + "\n" + "fCanRetransform" + " = " + this.fCanRetransform + "\n" + "fCanRedefine" + " = " + this.fCanRedefine + "\n" + "fIsIBM" + " = " + this.fIsIBM + "\n" + "fForceIBM" + " = " + this.fForceIBM + "\n" + "fisJava15" + " = " + this.fisJava15 + "\n" + "fSuggestRetransform" + " = " + this.fSuggestRetransform + "\n" + "fPropertyForceRedefinition" + " = " + this.fPropertyForceRedefinition + "\n" + "fPropertyForceRetransformation" + " = " + this.fPropertyForceRetransformation + "\n" + "fUseNullTransformer" + " = " + this.fUseNullTransformer + "\n";
    }

    private static void error(JavaRedefineRetransformBean result, String string) {
        Date d = new Date();
        System.out.println(d + " [ERROR] [JavaAgent] " + " <" + Thread.currentThread().getName() + "> " + string);
        System.err.println(d + " [ERROR] [JavaAgent] " + " <" + Thread.currentThread().getName() + "> " + string);
    }

    static void warn(JavaRedefineRetransformBean result, String string) {
        Date d = new Date();
        System.out.println(d + " [WARN] [JavaAgent] " + " <" + Thread.currentThread().getName() + "> " + string);
        System.err.println(d + " [WARN] [JavaAgent] " + " <" + Thread.currentThread().getName() + "> " + string);
    }

    static void info(JavaRedefineRetransformBean result, String string) {
        Date d = new Date();
        System.out.println(d + " [INFO] [JavaAgent] " + " <" + Thread.currentThread().getName() + "> " + string);
        System.err.println(d + " [INFO] [JavaAgent] " + " <" + Thread.currentThread().getName() + "> " + string);
    }

    static void debug(JavaRedefineRetransformBean result, String string) {
        if (result.fVerbose) {
            System.out.println(new Date() + " [DEBUG] [JavaAgent] " + " <" + Thread.currentThread().getName() + "> " + string);
        }
    }

    static JavaRedefineRetransformBean getJavaRedefineRetransformBeanInfo(String agentArgs, Instrumentation instrumentation) {
        Method instrumentationIsRetransformClassesSupported;
        JavaRedefineRetransformBean result = new JavaRedefineRetransformBean();
        String property = null;
        property = System.getProperty("java.specification.version");
        JavaRedefineRetransformBean.debug(result, "java.specification.version=" + property);
        if (property != null && property.startsWith("1.5")) {
            result.fisJava15 = true;
        }
        property = System.getProperty("java.vendor");
        JavaRedefineRetransformBean.debug(result, "java.vendor=" + property);
        if (property != null && property.startsWith("IBM")) {
            result.fIsIBM = true;
        }
        if (agentArgs != null) {
            String[] args = agentArgs.split(",");
            int i = 0;
            while (i < args.length) {
                String[] arg1 = args[i].split("=");
                if (arg1.length == 2) {
                    if (arg1[0].equalsIgnoreCase("forceRedefineDelegate")) {
                        result.fPropertyForceRedefinition = Boolean.parseBoolean(arg1[1]);
                    }
                    if (arg1[0].equalsIgnoreCase("forceRetransformDelegate")) {
                        result.fPropertyForceRetransformation = Boolean.parseBoolean(arg1[1]);
                    }
                    if (arg1[0].equalsIgnoreCase("enableRetransformForTransformer")) {
                        result.fSuggestRetransform = Boolean.parseBoolean(arg1[1]);
                    }
                    if (arg1[0].equalsIgnoreCase("verbose")) {
                        result.fVerbose = Boolean.parseBoolean(arg1[1]);
                    }
                    if (arg1[0].equalsIgnoreCase("usenull")) {
                        result.fUseNullTransformer = Boolean.parseBoolean(arg1[1]);
                    }
                }
                ++i;
            }
        }
        JavaRedefineRetransformBean.debug(result, agentArgs);
        property = System.getProperty("introscope.autoprobe.dynamicinstrument.forceRedefinition");
        JavaRedefineRetransformBean.debug(result, "introscope.autoprobe.dynamicinstrument.forceRedefinition=" + property);
        if (property != null) {
            result.fPropertyForceRedefinition = Boolean.parseBoolean(property);
        }
        property = System.getProperty("introscope.autoprobe.dynamicinstrument.forceRetransformation");
        JavaRedefineRetransformBean.debug(result, "introscope.autoprobe.dynamicinstrument.forceRetransformation=" + property);
        if (property != null) {
            result.fPropertyForceRetransformation = Boolean.parseBoolean(property);
        }
        if (!result.fisJava15) {
            try {
                instrumentationIsRetransformClassesSupported = instrumentation.getClass().getMethod("isRetransformClassesSupported", null);
                Boolean isRetransformedEnabled = (Boolean)instrumentationIsRetransformClassesSupported.invoke((Object)instrumentation, null);
                result.fCanRetransform = isRetransformedEnabled;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                JavaRedefineRetransformBean.debug(result, t.getMessage());
            }
        }
        try {
            instrumentationIsRetransformClassesSupported = instrumentation.getClass().getMethod("isRedefineClassesSupported", null);
            Boolean isRedefineEnabled = (Boolean)instrumentationIsRetransformClassesSupported.invoke((Object)instrumentation, null);
            result.fCanRedefine = isRedefineEnabled;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            JavaRedefineRetransformBean.debug(result, t.getMessage());
        }
        result.checkIBM();
        if (result.fPropertyForceRedefinition && result.fPropertyForceRetransformation) {
            JavaRedefineRetransformBean.debug(result, "Argument forceRetransformDelegate and forceRedefineDelegate, and System properties introscope.autoprobe.dynamicinstrument.forceRedefinition and introscope.autoprobe.dynamicinstrument.forceRetransformation are set to be defined both true. The agent will act as force redefinition is true");
            result.fPropertyForceRedefinition = false;
        }
        if (result.fPropertyForceRetransformation && result.fCanRetransform) {
            result.fSuggestRetransform = true;
        }
        if (result.fisJava15) {
            if (result.fPropertyForceRetransformation) {
                JavaRedefineRetransformBean.warn(result, "System property introscope.autoprobe.dynamicinstrument.forceRetransformation is set to true even if the agent is running in Java 5. The value will be set to false");
                result.fPropertyForceRetransformation = false;
            }
            if (result.fSuggestRetransform) {
                JavaRedefineRetransformBean.warn(result, "Argument enableRetransformForTransformer is set to true even if the agent is running in Java 5. The value will be set to false");
                result.fSuggestRetransform = false;
            }
        }
        if (!result.fCanRedefine && result.fPropertyForceRedefinition) {
            JavaRedefineRetransformBean.warn(result, "Argument forceRedefineDelegate or System property introscope.autoprobe.dynamicinstrument.forceRedefition are  set to true even if the agent is not able to redefine. The value will be set to false");
            result.fPropertyForceRedefinition = false;
        }
        if (!result.fCanRetransform) {
            if (result.fPropertyForceRetransformation) {
                JavaRedefineRetransformBean.warn(result, "Argument forceRetransformDelegate or System property introscope.autoprobe.dynamicinstrument.forceRetransformation are  set to true even if the agent is not able to retransform. The value will be set to false");
                result.fPropertyForceRetransformation = false;
            }
            if (result.fSuggestRetransform) {
                JavaRedefineRetransformBean.warn(result, "Argument enableRetransformForTransformer is set to true even if the agent is not able to retransform. The value will not be set as false");
                result.fSuggestRetransform = false;
            }
        }
        if (result.fVerbose) {
            System.out.print(result.toString());
        }
        return result;
    }
}

