/*
 * Decompiled with CFR 0.152.
 */
package com.wily.org.apache.log4j.net;

import com.wily.org.apache.log4j.AppenderSkeleton;
import com.wily.org.apache.log4j.helpers.CyclicBuffer;
import com.wily.org.apache.log4j.helpers.LogLog;
import com.wily.org.apache.log4j.helpers.OptionConverter;
import com.wily.org.apache.log4j.net.DefaultEvaluator;
import com.wily.org.apache.log4j.spi.LoggingEvent;
import com.wily.org.apache.log4j.spi.TriggeringEventEvaluator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class SMTPAppender
extends AppenderSkeleton {
    private String to;
    private String from;
    private String subject;
    private String smtpHost;
    private int bufferSize = 512;
    private boolean locationInfo = false;
    protected CyclicBuffer cb = new CyclicBuffer(this.bufferSize);
    protected Message msg;
    protected TriggeringEventEvaluator evaluator;
    static /* synthetic */ Class class$0;

    public SMTPAppender() {
        this(new DefaultEvaluator());
    }

    public SMTPAppender(TriggeringEventEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public void activateOptions() {
        Properties props = new Properties(System.getProperties());
        if (this.smtpHost != null) {
            ((Hashtable)props).put("mail.smtp.host", this.smtpHost);
        }
        Session session = Session.getInstance((Properties)props, null);
        this.msg = new MimeMessage(session);
        try {
            if (this.from != null) {
                this.msg.setFrom((Address)this.getAddress(this.from));
            } else {
                this.msg.setFrom();
            }
            this.msg.setRecipients(Message.RecipientType.TO, (Address[])this.parseAddress(this.to));
            if (this.subject != null) {
                this.msg.setSubject(this.subject);
            }
        }
        catch (MessagingException e) {
            LogLog.error("Could not activate SMTPAppender options.", e);
        }
    }

    public void append(LoggingEvent event) {
        if (!this.checkEntryConditions()) {
            return;
        }
        event.getThreadName();
        event.getNDC();
        if (this.locationInfo) {
            event.getLocationInformation();
        }
        this.cb.add(event);
        if (this.evaluator.isTriggeringEvent(event)) {
            this.sendBuffer();
        }
    }

    protected boolean checkEntryConditions() {
        if (this.msg == null) {
            this.errorHandler.error("Message object not configured.");
            return false;
        }
        if (this.evaluator == null) {
            this.errorHandler.error("No TriggeringEventEvaluator is set for appender [" + this.name + "].");
            return false;
        }
        if (this.layout == null) {
            this.errorHandler.error("No layout set for appender named [" + this.name + "].");
            return false;
        }
        return true;
    }

    public synchronized void close() {
        this.closed = true;
    }

    InternetAddress getAddress(String addressStr) {
        try {
            return new InternetAddress(addressStr);
        }
        catch (AddressException e) {
            this.errorHandler.error("Could not parse address [" + addressStr + "].", (Exception)((Object)e), 6);
            return null;
        }
    }

    InternetAddress[] parseAddress(String addressStr) {
        try {
            return InternetAddress.parse((String)addressStr, (boolean)true);
        }
        catch (AddressException e) {
            this.errorHandler.error("Could not parse address [" + addressStr + "].", (Exception)((Object)e), 6);
            return null;
        }
    }

    public String getTo() {
        return this.to;
    }

    public boolean requiresLayout() {
        return true;
    }

    protected void sendBuffer() {
        try {
            MimeBodyPart part = new MimeBodyPart();
            StringBuffer sbuf = new StringBuffer();
            String t = this.layout.getHeader();
            if (t != null) {
                sbuf.append(t);
            }
            int len = this.cb.length();
            int i = 0;
            while (i < len) {
                String[] s;
                LoggingEvent event = this.cb.get();
                sbuf.append(this.layout.format(event));
                if (this.layout.ignoresThrowable() && (s = event.getThrowableStrRep()) != null) {
                    int j = 0;
                    while (j < s.length) {
                        sbuf.append(s[j]);
                        ++j;
                    }
                }
                ++i;
            }
            t = this.layout.getFooter();
            if (t != null) {
                sbuf.append(t);
            }
            part.setContent((Object)sbuf.toString(), this.layout.getContentType());
            MimeMultipart mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)part);
            this.msg.setContent((Multipart)mp);
            this.msg.setSentDate(new Date());
            Transport.send((Message)this.msg);
        }
        catch (Exception e) {
            LogLog.error("Error occured while sending e-mail notification.", e);
        }
    }

    public String getEvaluatorClass() {
        return this.evaluator == null ? null : this.evaluator.getClass().getName();
    }

    public String getFrom() {
        return this.from;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        this.cb.resize(bufferSize);
    }

    public void setSMTPHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public String getSMTPHost() {
        return this.smtpHost;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setEvaluatorClass(String value) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.wily.org.apache.log4j.spi.TriggeringEventEvaluator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.evaluator = (TriggeringEventEvaluator)OptionConverter.instantiateByClassName(value, clazz, this.evaluator);
    }

    public void setLocationInfo(boolean locationInfo) {
        this.locationInfo = locationInfo;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }
}

