/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.environment;

import com.wily.introscope.agent.environment.UnsignedByteArray;

public class SubNetworkDescriptor {
    private final boolean isIPv4Address;
    private final UnsignedByteArray firstAddress;
    private final UnsignedByteArray netMask;

    public SubNetworkDescriptor(String firstAddress, int range) throws IllegalArgumentException {
        boolean bl = this.isIPv4Address = firstAddress.indexOf(58) < 0;
        if (this.isIPv4Address) {
            this.firstAddress = new UnsignedByteArray(firstAddress, 4, 1, 3, ".", true);
            this.netMask = new UnsignedByteArray(4, range);
        } else {
            this.firstAddress = new UnsignedByteArray(firstAddress, 16, 2, 4, ":", false);
            this.netMask = new UnsignedByteArray(16, range);
        }
    }

    public boolean isInSubNet(UnsignedByteArray ipAddress) {
        return this.firstAddress.equals(ipAddress.and(this.netMask));
    }

    public boolean isIPv4() {
        return this.isIPv4Address;
    }

    public UnsignedByteArray getFirstAddress() {
        return this.firstAddress;
    }

    public UnsignedByteArray getNetMask() {
        return this.netMask;
    }
}

