/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.subscription;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.extension.DuplicateDynamicClassException;
import com.wily.introscope.agent.extension.ExtensionAdministrator;
import com.wily.introscope.agent.extension.InstantiableDynamicClassLookup;
import com.wily.introscope.agent.extension.InvalidDynamicClassException;
import com.wily.introscope.agent.subscription.ISubscriber;
import com.wily.introscope.agent.subscription.ISubscriberAdministrator;
import com.wily.util.extension.ExtensionUtilities;
import com.wily.util.extension.IPlugin;
import com.wily.util.feedback.Module;
import com.wily.wilyassert.Assertion;
import java.util.HashMap;
import java.util.Map;

public class SubscriberAdministrator
extends InstantiableDynamicClassLookup
implements ISubscriberAdministrator {
    private static final Module kModule = new Module("SubscriberAdministrator");
    private static final String kSubscriberPluginType = "subscriber";
    private static final int kCurrentSubscriberPluginVersion = 1;
    private final Map fSubscribers = new HashMap();
    private static final Class[] kSubscriberConstructorParameterTypes = new Class[]{IAgent.class};

    public SubscriberAdministrator(IAgent agent) {
        super(agent, ISubscriber.class, kSubscriberConstructorParameterTypes);
        this.loadSubscribers();
    }

    @Override
    protected Object[] getConstructorParameters(IAgent dynamicAgent) {
        return new Object[]{dynamicAgent};
    }

    private void loadSubscribers() {
        ExtensionAdministrator extensionAdministrator = this.getAgent().IAgent_getExtensionAdministrator();
        Assertion.wilyAssert(false);
        IPlugin[] plugins = extensionAdministrator.getAgentPluginsByType(kSubscriberPluginType);
        int i = 0;
        while (i < plugins.length) {
            Class subscriber = ExtensionUtilities.loadEntryPointClass(this.getModuleFeedback(), this.getStringLocalizer(), plugins[i], 1, ISubscriber.class);
            if (subscriber != null) {
                try {
                    this.register(plugins[i], plugins[i].IPlugin_getName(), subscriber, plugins[i].IPlugin_getOwningExtension().IExtension_getStringLocalizer(this.getStringLocalizer()));
                }
                catch (DuplicateDynamicClassException e) {
                    this.getModuleFeedback().error(kModule, "Duplicate subscriber registration for plugin " + plugins[i].IPlugin_getName() + " in extension " + plugins[i].IPlugin_getOwningExtension().IExtension_getName() + " from " + plugins[i].IPlugin_getOwningExtension().IExtension_getSource(), e);
                }
                catch (InvalidDynamicClassException e) {
                    this.getModuleFeedback().error(kModule, "Invalid subscriber registration for plugin " + plugins[i].IPlugin_getName() + " in extension " + plugins[i].IPlugin_getOwningExtension().IExtension_getName() + " from " + plugins[i].IPlugin_getOwningExtension().IExtension_getSource(), e);
                }
                this.getSubscriber(plugins[i].IPlugin_getName());
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISubscriber getSubscriber(String subscriberPluginName) {
        ISubscriber subscriber = (ISubscriber)this.fSubscribers.get(subscriberPluginName);
        if (subscriber == null) {
            Map map = this.fSubscribers;
            synchronized (map) {
                subscriber = (ISubscriber)this.fSubscribers.get(subscriberPluginName);
                if (subscriber == null && (subscriber = (ISubscriber)this.load(subscriberPluginName)) != null) {
                    this.fSubscribers.put(subscriberPluginName, subscriber);
                }
            }
        }
        if (subscriber == null) {
            this.getModuleFeedback().error(kModule, "Subscriber Plugin " + subscriberPluginName + " not found");
        }
        return subscriber;
    }
}

