/*
 * Decompiled with CFR 0.152.
 */
package com.wily.org.apache.log4j.performance;

import java.util.Date;

public class ConcatVsArray {
    static void Usage() {
        System.err.println("Usage: java com.wily.org.apache.log4j.performance.ConcatVsArray string1 string2 runLength\n       where runLength is an integer.");
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            ConcatVsArray.Usage();
        }
        String s1 = args[0];
        String s2 = args[1];
        int runLength = 0;
        try {
            runLength = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException e) {
            System.err.println(e);
            ConcatVsArray.Usage();
        }
        long before = new Date().getTime();
        int i = 0;
        while (i < runLength) {
            String[] stringArray = new String[]{s1, s2};
            ++i;
        }
        double micros = (double)(new Date().getTime() - before) * 1000.0 / (double)runLength;
        System.out.println("The anonymous array loop took around " + micros + " microseconds.");
        before = new Date().getTime();
        i = 0;
        while (i < runLength) {
            String cfr_ignored_0 = String.valueOf(s1) + s2;
            ++i;
        }
        micros = (double)(new Date().getTime() - before) * 1000.0 / (double)runLength;
        System.out.println("The append loop took around " + micros + " microseconds.");
    }
}

